/// <reference path="./internal_*.d.ts" />
declare namespace owmii.powah.lib.logistics.inventory {
    class Inventory extends Internal.ItemStackHandler {
        constructor(stacks: Internal.Stacks_, tile: Internal.IInventoryHolder_)
        constructor(stacks: Internal.Stacks_)
        constructor(size: number)
        removeNext(): Internal.ItemStack;
        canPut(outputs: Internal.Stacks_, ...slots: number[]): Internal.Stacks;
        fromSlotArray(...slots: number[]): Internal.Stacks;
        getNonEmptyStacks(): Internal.List<Internal.ItemStack>;
        drop(world: Internal.Level_, pos: BlockPos_): void;
        getStacks(): Internal.Stacks;
        setTile(tile: Internal.IInventoryHolder_): void;
        isBlank(): boolean;
        isEmpty(): boolean;
        canPut(outputs: Internal.Stacks_, slots: Internal.Stacks_): Internal.Stacks;
        getLast(): Internal.ItemStack;
        hasEmptySlot(): boolean;
        static createBlank(): owmii.powah.lib.logistics.inventory.Inventory;
        getLastSlot(): number;
        setSlotEmpty(slot: number): Internal.ItemStack;
        insertItem(stack: Internal.ItemStack_, simulate: boolean, ...ex: number[]): Internal.ItemStack;
        extractItemFromSlot(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        isSlotEmpty(slot: number): boolean;
        isFull(): boolean;
        setSendUpdates(sendUpdates: boolean): void;
        static calcRedstone(inv: Internal.ItemStackHandler_): number;
        onContentsChanged(slot: number): void;
        static createBlank<I extends Internal.AbstractTileEntity<any, any> & Internal.IInventoryHolder>(tile: I): owmii.powah.lib.logistics.inventory.Inventory;
        getPlatformWrapper(): any;
        addNext(stack: Internal.ItemStack_): Internal.ItemStack;
        add(size: number): this;
        canExtract(slot: number, stack: Internal.ItemStack_): boolean;
        set(size: number): this;
        getLast(count: number): Internal.Stacks;
        static create(size: number): owmii.powah.lib.logistics.inventory.Inventory;
        clear(): void;
        static create<I extends Internal.AbstractTileEntity<any, any> & Internal.IInventoryHolder>(size: number, tile: I): owmii.powah.lib.logistics.inventory.Inventory;
        getFirst(): Internal.ItemStack;
        drop(index: number, world: Internal.Level_, pos: BlockPos_): void;
        get nonEmptyStacks(): Internal.List<Internal.ItemStack>
        get stacks(): Internal.Stacks
        set tile(tile: Internal.IInventoryHolder_)
        get blank(): boolean
        get empty(): boolean
        get last(): Internal.ItemStack
        get lastSlot(): number
        set slotEmpty(slot: number)
        get full(): boolean
        set sendUpdates(sendUpdates: boolean)
        get platformWrapper(): any
        get first(): Internal.ItemStack
    }
    type Inventory_ = Inventory;
}
declare namespace com.simibubi.create.foundation.mixin.accessor {
    interface ServerLevelAccessor {
        abstract create$getEntityTickList(): Internal.EntityTickList;
        (): Internal.EntityTickList_;
    }
    type ServerLevelAccessor_ = ServerLevelAccessor;
}
declare namespace dev.architectury.event {
    interface Event <T> {
        abstract invoker(): T;
        abstract unregister(arg0: T): void;
        abstract register(arg0: T): void;
        abstract isRegistered(arg0: T): boolean;
        abstract clearListeners(): void;
    }
    type Event_<T> = Event<T>;
}
declare namespace Internal {
    interface FabricElytraItem {
        doVanillaElytraTick(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_): void;
        useCustomElytra(entity: Internal.LivingEntity_, chestStack: Internal.ItemStack_, tickElytra: boolean): boolean;
    }
    type FabricElytraItem_ = FabricElytraItem;
    class BlockPositionSource implements Internal.PositionSource {
        constructor($$0: BlockPos_)
        getType(): Internal.PositionSourceType<any>;
        getPosition($$0: Internal.Level_): Internal.Optional<Vec3d>;
        get type(): Internal.PositionSourceType<any>
        static readonly CODEC: Internal.Codec<Internal.BlockPositionSource>;
    }
    type BlockPositionSource_ = BlockPositionSource;
    interface OptionInstance$TooltipSupplier <T> {
        abstract apply(arg0: T): Internal.Tooltip;
        (arg0: T): Internal.Tooltip_;
    }
    type OptionInstance$TooltipSupplier_<T> = OptionInstance$TooltipSupplier<T>;
    interface IStandardBogeyTEVirtualCoupling {
        abstract getCouplingDistance(): number;
        abstract setCouplingDistance(arg0: number): void;
        abstract getFront(): boolean;
        abstract setFront(arg0: boolean): void;
        abstract getCouplingDirection(): Internal.Direction;
        abstract setCouplingDirection(arg0: Internal.Direction_): void;
        get couplingDistance(): number
        set couplingDistance(arg0: number)
        get front(): boolean
        set front(arg0: boolean)
        get couplingDirection(): Internal.Direction
        set couplingDirection(arg0: Internal.Direction_)
    }
    type IStandardBogeyTEVirtualCoupling_ = IStandardBogeyTEVirtualCoupling;
    class GameConfig$QuickPlayData extends Internal.Record {
        constructor($$0: string, $$1: string, $$2: string, $$3: string)
        realms(): string;
        multiplayer(): string;
        path(): string;
        singleplayer(): string;
        isEnabled(): boolean;
        get enabled(): boolean
    }
    type GameConfig$QuickPlayData_ = GameConfig$QuickPlayData;
    interface MessageSizeEstimator {
        abstract newHandle(): Internal.MessageSizeEstimator$Handle;
        (): Internal.MessageSizeEstimator$Handle_;
    }
    type MessageSizeEstimator_ = MessageSizeEstimator;
    class QuarterProperty extends Internal.Enum<Internal.QuarterProperty> implements Internal.StringRepresentable {
        static values(): Internal.QuarterProperty[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getName(): string;
        static valueOf(name: string): Internal.QuarterProperty;
        get serializedName(): string
        get name(): string
        static readonly SOUTH_WEST: Internal.QuarterProperty;
        static readonly NORTH_EAST: Internal.QuarterProperty;
        static readonly SOUTH_EAST: Internal.QuarterProperty;
        static readonly NORTH_WEST: Internal.QuarterProperty;
    }
    type QuarterProperty_ = "north_west" | "north_east" | "south_west" | QuarterProperty | "south_east";
    class BlockColumnFeature extends Internal.Feature<Internal.BlockColumnConfiguration> {
        constructor($$0: Internal.Codec_<Internal.BlockColumnConfiguration>)
    }
    type BlockColumnFeature_ = BlockColumnFeature;
    abstract class MeltingRecipe$AbstractSerializer <T extends Internal.MeltingRecipe> extends Internal.LoggingRecipeSerializer<T> {
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
    }
    type MeltingRecipe$AbstractSerializer_<T extends Internal.MeltingRecipe> = MeltingRecipe$AbstractSerializer<T>;
    class BiomeManager implements Internal.BiomeManagerAccessor {
        constructor($$0: Internal.BiomeManager$NoiseBiomeSource_, $$1: number)
        port_lib$getBiomeZoomSeed(): number;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        withDifferentSource($$0: Internal.BiomeManager$NoiseBiomeSource_): this;
        getNoiseBiomeAtQuart($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        getNoiseBiomeAtPosition($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        static obfuscateSeed($$0: number): number;
        getNoiseBiomeAtPosition($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        static readonly CHUNK_CENTER_QUART: 2;
        readonly biomeZoomSeed: number;
    }
    type BiomeManager_ = BiomeManager;
    class ClientboundAddPlayerPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Player_)
        constructor($$0: Internal.FriendlyByteBuf_)
        getX(): number;
        handle(arg0: Internal.PacketListener_): void;
        getY(): number;
        getZ(): number;
        getPlayerId(): Internal.UUID;
        write($$0: Internal.FriendlyByteBuf_): void;
        getxRot(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getEntityId(): number;
        getyRot(): number;
        isSkippable(): boolean;
        get x(): number
        get y(): number
        get z(): number
        get playerId(): Internal.UUID
        get xRot(): number
        get entityId(): number
        get yRot(): number
        get skippable(): boolean
    }
    type ClientboundAddPlayerPacket_ = ClientboundAddPlayerPacket;
    class UmbranTreeFeature extends Internal.BOPTreeFeature<Internal.TaigaTreeConfiguration> {
        constructor(codec: Internal.Codec_<Internal.TaigaTreeConfiguration>)
        generateLeafLayer(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, leavesRadius: number, trunkStart: number, trunkEnd: number, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.TaigaTreeConfiguration_): void;
        checkSpace(world: Internal.LevelAccessor_, pos: BlockPos_, baseHeight: number, height: number, config: Internal.TaigaTreeConfiguration_): boolean;
        generateBranch(world: Internal.LevelAccessor_, rand: Internal.RandomSource_, pos: BlockPos_, direction: Internal.Direction_, length: number, logs: Internal.BiConsumer_<BlockPos, Internal.BlockState>, leaves: Internal.FoliagePlacer$FoliageSetter_, config: Internal.TaigaTreeConfiguration_): void;
    }
    type UmbranTreeFeature_ = UmbranTreeFeature;
    interface IDebugDrawer {
        abstract drawDebug(): void;
        (): void;
    }
    type IDebugDrawer_ = IDebugDrawer;
    class ShulkerBoxColoring extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type ShulkerBoxColoring_ = ShulkerBoxColoring;
    interface FabricBlockView {
        hasBiomes(): boolean;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
    }
    type FabricBlockView_ = FabricBlockView;
    class TrapDoorBlockBOP extends Internal.TrapDoorBlock {
        constructor($$1: Internal.BlockSetType_, $$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TrapDoorBlockBOP_ = TrapDoorBlockBOP;
    class SculkSpreader$ChargeCursor {
        constructor($$0: BlockPos_, $$1: number)
        getPos(): BlockPos;
        getCharge(): number;
        getFacingData(): Internal.Set<Internal.Direction>;
        getDecayDelay(): number;
        update($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.RandomSource_, $$3: Internal.SculkSpreader_, $$4: boolean): void;
        get pos(): BlockPos
        get charge(): number
        get facingData(): Internal.Set<Internal.Direction>
        get decayDelay(): number
        static readonly MAX_CURSOR_DECAY_DELAY: 1;
        static readonly CODEC: Internal.Codec<Internal.SculkSpreader$ChargeCursor>;
    }
    type SculkSpreader$ChargeCursor_ = SculkSpreader$ChargeCursor;
    interface IInventoryWrapperUpgrade {
        abstract wrapInventory(arg0: Internal.ITrackedContentsItemHandler_): Internal.ITrackedContentsItemHandler;
        (arg0: Internal.ITrackedContentsItemHandler): Internal.ITrackedContentsItemHandler_;
    }
    type IInventoryWrapperUpgrade_ = IInventoryWrapperUpgrade;
    class AntidoteVesselItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AntidoteVesselItem_ = AntidoteVesselItem;
    class SpecialHandlerNumberLiteral$Factory implements Internal.SpecialHandler$Factory<Internal.SpecialHandlerNumberLiteral> {
        constructor()
        tryMatch(pat: Internal.HexPattern_, env: Internal.CastingEnvironment_): Internal.SpecialHandlerNumberLiteral;
    }
    type SpecialHandlerNumberLiteral$Factory_ = SpecialHandlerNumberLiteral$Factory;
    abstract class AccessibleContext {
        getAccessibleComponent(): Internal.AccessibleComponent;
        getAccessibleEditableText(): Internal.AccessibleEditableText;
        setAccessibleParent(arg0: Internal.Accessible_): void;
        getAccessibleRelationSet(): Internal.AccessibleRelationSet;
        setAccessibleDescription(arg0: string): void;
        getAccessibleValue(): Internal.AccessibleValue;
        getAccessibleText(): Internal.AccessibleText;
        setAccessibleName(arg0: string): void;
        getAccessibleTable(): Internal.AccessibleTable;
        abstract getAccessibleIndexInParent(): number;
        removePropertyChangeListener(arg0: Internal.PropertyChangeListener_): void;
        firePropertyChange(arg0: string, arg1: any, arg2: any): void;
        abstract getLocale(): Internal.Locale;
        getAccessibleSelection(): Internal.AccessibleSelection;
        getAccessibleAction(): Internal.AccessibleAction;
        addPropertyChangeListener(arg0: Internal.PropertyChangeListener_): void;
        abstract getAccessibleChild(arg0: number): Internal.Accessible;
        getAccessibleName(): string;
        abstract getAccessibleRole(): Internal.AccessibleRole;
        getAccessibleIcon(): any[];
        abstract getAccessibleStateSet(): Internal.AccessibleStateSet;
        abstract getAccessibleChildrenCount(): number;
        getAccessibleParent(): Internal.Accessible;
        getAccessibleDescription(): string;
        get accessibleComponent(): Internal.AccessibleComponent
        get accessibleEditableText(): Internal.AccessibleEditableText
        set accessibleParent(arg0: Internal.Accessible_)
        get accessibleRelationSet(): Internal.AccessibleRelationSet
        set accessibleDescription(arg0: string)
        get accessibleValue(): Internal.AccessibleValue
        get accessibleText(): Internal.AccessibleText
        set accessibleName(arg0: string)
        get accessibleTable(): Internal.AccessibleTable
        get accessibleIndexInParent(): number
        get locale(): Internal.Locale
        get accessibleSelection(): Internal.AccessibleSelection
        get accessibleAction(): Internal.AccessibleAction
        get accessibleName(): string
        get accessibleRole(): Internal.AccessibleRole
        get accessibleIcon(): any[]
        get accessibleStateSet(): Internal.AccessibleStateSet
        get accessibleChildrenCount(): number
        get accessibleParent(): Internal.Accessible
        get accessibleDescription(): string
        static readonly ACCESSIBLE_CHILD_PROPERTY: "AccessibleChild";
        static readonly ACCESSIBLE_COMPONENT_BOUNDS_CHANGED: "accessibleComponentBoundsChanged";
        static readonly ACCESSIBLE_STATE_PROPERTY: "AccessibleState";
        static readonly ACCESSIBLE_TABLE_COLUMN_DESCRIPTION_CHANGED: "accessibleTableColumnDescriptionChanged";
        static readonly ACCESSIBLE_TABLE_SUMMARY_CHANGED: "accessibleTableSummaryChanged";
        static readonly ACCESSIBLE_NAME_PROPERTY: "AccessibleName";
        static readonly ACCESSIBLE_TEXT_ATTRIBUTES_CHANGED: "accessibleTextAttributesChanged";
        static readonly ACCESSIBLE_ACTION_PROPERTY: "accessibleActionProperty";
        static readonly ACCESSIBLE_HYPERTEXT_OFFSET: "AccessibleHypertextOffset";
        static readonly ACCESSIBLE_INVALIDATE_CHILDREN: "accessibleInvalidateChildren";
        static readonly ACCESSIBLE_VALUE_PROPERTY: "AccessibleValue";
        static readonly ACCESSIBLE_TEXT_PROPERTY: "AccessibleText";
        static readonly ACCESSIBLE_ACTIVE_DESCENDANT_PROPERTY: "AccessibleActiveDescendant";
        static readonly ACCESSIBLE_TABLE_MODEL_CHANGED: "accessibleTableModelChanged";
        static readonly ACCESSIBLE_CARET_PROPERTY: "AccessibleCaret";
        static readonly ACCESSIBLE_TABLE_CAPTION_CHANGED: "accessibleTableCaptionChanged";
        static readonly ACCESSIBLE_TABLE_COLUMN_HEADER_CHANGED: "accessibleTableColumnHeaderChanged";
        static readonly ACCESSIBLE_DESCRIPTION_PROPERTY: "AccessibleDescription";
        static readonly ACCESSIBLE_VISIBLE_DATA_PROPERTY: "AccessibleVisibleData";
        static readonly ACCESSIBLE_TABLE_ROW_HEADER_CHANGED: "accessibleTableRowHeaderChanged";
        static readonly ACCESSIBLE_SELECTION_PROPERTY: "AccessibleSelection";
        static readonly ACCESSIBLE_TABLE_ROW_DESCRIPTION_CHANGED: "accessibleTableRowDescriptionChanged";
    }
    type AccessibleContext_ = AccessibleContext;
    interface ValueLayout$OfFloat extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type ValueLayout$OfFloat_ = ValueLayout$OfFloat;
    class TableClothBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TableClothBlockItem_ = TableClothBlockItem;
    interface FabricLootPoolBuilder {
        "with"(entry: Internal.LootPoolEntryContainer_): Internal.LootPool$Builder;
        copyOf(pool: Internal.LootPool_): Internal.LootPool$Builder;
        "with"(entries: Internal.Collection_<Internal.LootPoolEntryContainer>): Internal.LootPool$Builder;
        conditionally(conditions: Internal.Collection_<Internal.LootItemCondition>): Internal.LootPool$Builder;
        conditionally(condition: Internal.LootItemCondition_): Internal.LootPool$Builder;
        apply(functions: Internal.Collection_<Internal.LootItemFunction>): Internal.LootPool$Builder;
        apply(function_: Internal.LootItemFunction_): Internal.LootPool$Builder;
    }
    type FabricLootPoolBuilder_ = FabricLootPoolBuilder;
    abstract class AbstractFurnaceBlockEntity extends Internal.BaseContainerBlockEntity implements Internal.InventoryChangeTracker, Internal.SleepingBlockEntity, Internal.StackedContentsCompatible, Internal.AccessorAbstractFurnaceBlockEntity, Internal.RecipeHolder, Internal.WorldlyContainer, Internal.SpecialLogicInventory, Internal.LithiumInventory {
        stopOpen($$0: Internal.Player_): void;
        static serverTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.AbstractFurnaceBlockEntity_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        fabric_setSuppress(suppress: boolean): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getItems(): Internal.NonNullList<any>;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        awardUsedRecipes($$0: Internal.Player_, $$1: Internal.List_<Internal.ItemStack>): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isSleeping(): boolean;
        setChanged(): void;
        static getFuel(): Internal.Map<Internal.Item, number>;
        onLoad(): void;
        fabric_onFinalCommit(slot: number, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getSlotsForFace($$0: Internal.Direction_): number[];
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        awardUsedRecipesAndPopExperience($$0: Internal.ServerPlayer_): void;
        getSleepingTicker(): Internal.TickingBlockEntity;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        static add($$0: Internal.Map_<Internal.Item, number>, $$1: Internal.TagKey_<Internal.Item>, $$2: number): void;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        setTickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getRecipeUsed(): Internal.Recipe<any>;
        wakeUpNow(): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        setRecipeUsed($$0: Internal.Recipe_<any>): void;
        static add($$0: Internal.Map_<Internal.Item, number>, $$1: Internal.ItemLike_, $$2: number): void;
        canTakeItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        static isFuel($$0: Internal.ItemStack_): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        canPlaceItemThroughFace($$0: number, $$1: Internal.ItemStack_, $$2: Internal.Direction_): boolean;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        setRecipeUsed($$0: Internal.Level_, $$1: Internal.ServerPlayer_, $$2: Internal.Recipe_<any>): boolean;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        fillStackedContents($$0: Internal.StackedContents_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        "handler$cma000$fabric-transfer-api-v1$setStackSuppressUpdate"(slot: number, stack: Internal.ItemStack_, ci: Internal.CallbackInfo_): void;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        setSleepingTicker(sleepingTicker: Internal.TickingBlockEntity_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        getRecipesToAwardAndPopExperience($$0: Internal.ServerLevel_, $$1: Vec3d_): Internal.List<Internal.Recipe<any>>;
        get items(): Internal.NonNullList<any>
        get slots(): number
        get sleeping(): boolean
        get fuel(): Internal.Map<Internal.Item, number>
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get sleepingTicker(): Internal.TickingBlockEntity
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set tickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_)
        get recipeUsed(): Internal.Recipe<any>
        set ticker(delegate: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        set recipeUsed($$0: Internal.Recipe_<any>)
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        set sleepingTicker(sleepingTicker: Internal.TickingBlockEntity_)
        readonly dataAccess: Internal.ContainerData;
        static readonly DATA_LIT_DURATION: 1;
        static readonly DATA_COOKING_PROGRESS: 2;
        static readonly NUM_DATA_VALUES: 4;
        static readonly DATA_LIT_TIME: 0;
        litTime: number;
        static readonly BURN_TIME_STANDARD: 200;
        static readonly BURN_COOL_SPEED: 2;
        static readonly DATA_COOKING_TOTAL_TIME: 3;
    }
    type AbstractFurnaceBlockEntity_ = AbstractFurnaceBlockEntity;
    class ItemVaultMountedStorage extends Internal.WrapperMountedItemStorage<io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler> {
        static fromVault(vault: Internal.ItemVaultBlockEntity_): Internal.ItemVaultMountedStorage;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        static fromLegacy(nbt: Internal.CompoundTag_): Internal.ItemVaultMountedStorage;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static empty<T>(): Internal.Storage<T>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        static asClass<T>(): Internal.Storage<T>;
        static readonly CODEC: Internal.Codec<Internal.ItemVaultMountedStorage>;
    }
    type ItemVaultMountedStorage_ = ItemVaultMountedStorage;
    class TagEntry {
        static tag($$0: ResourceLocation_): Internal.TagEntry;
        build<T>($$0: Internal.TagEntry$Lookup_<T>, $$1: Internal.Consumer_<T>): boolean;
        visitOptionalDependencies($$0: Internal.Consumer_<ResourceLocation>): void;
        verifyIfPresent($$0: Internal.Predicate_<ResourceLocation>, $$1: Internal.Predicate_<ResourceLocation>): boolean;
        static element($$0: ResourceLocation_): Internal.TagEntry;
        elementOrTag(): Internal.ExtraCodecs$TagOrElementLocation;
        static optionalTag($$0: ResourceLocation_): Internal.TagEntry;
        visitRequiredDependencies($$0: Internal.Consumer_<ResourceLocation>): void;
        static optionalElement($$0: ResourceLocation_): Internal.TagEntry;
        readonly required: boolean;
        readonly id: ResourceLocation;
        static readonly CODEC: Internal.Codec<Internal.TagEntry>;
        readonly tag: boolean;
    }
    type TagEntry_ = TagEntry;
    class CanerMode extends Internal.Enum<Internal.CanerMode> {
        static valueOf(name: string): Internal.CanerMode;
        static values(): Internal.CanerMode[];
        static readonly FILL: Internal.CanerMode;
        static readonly EMPTY: Internal.CanerMode;
    }
    type CanerMode_ = "empty" | CanerMode | "fill";
    class BackpackItem extends Internal.ItemBase implements Internal.IStashStorageItem, Internal.Equipable {
        constructor(numberOfSlots: Internal.IntSupplier_, numberOfUpgradeSlots: Internal.IntSupplier_, blockSupplier: Internal.Supplier_<Internal.BackpackBlock>)
        constructor(numberOfSlots: Internal.IntSupplier_, numberOfUpgradeSlots: Internal.IntSupplier_, blockSupplier: Internal.Supplier_<Internal.BackpackBlock>, updateProperties: Internal.UnaryOperator_<Internal.Item$Properties>)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static initCapabilities(): Internal.ItemApiLookup$ItemApiProvider<Internal.LazyOptional<Internal.IBackpackWrapper>, void>;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        getInventoryTooltip(stack: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getEquipSound(): Internal.SoundEvent;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getEquipmentSlot(): Internal.EquipmentSlot;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        tryPlace(player: Internal.Player_, direction: Internal.Direction_, blockItemUseContext: Internal.BlockPlaceContext_): Internal.InteractionResult;
        getNumberOfSlots(): number;
        emi(amount: number): Internal.EmiStack;
        getItemStashable(storageStack: Internal.ItemStack_, stack: Internal.ItemStack_): Internal.IStashStorageItem$StashResult;
        createCustomEntity(world: Internal.Level_, entity: Internal.Entity_, itemstack: Internal.ItemStack_): Internal.Entity;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        stash(storageStack: Internal.ItemStack_, stack: Internal.ItemStack_, ctx: Internal.Transaction_): Internal.ItemStack;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getNumberOfUpgradeSlots(): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get equipmentSlot(): Internal.EquipmentSlot
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get numberOfSlots(): number
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get numberOfUpgradeSlots(): number
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BackpackItem_ = BackpackItem;
    class CastingImage {
        constructor()
        constructor(stack: Internal.List_<any>, parenCount: number, parenthesized: Internal.List_<any>, escapeNext: boolean, opsConsumed: number, userData: Internal.CompoundTag_, $constructor_marker: any_)
        component2(): number;
        component5(): number;
        copy(stack: Internal.List_<Internal.Iota>, parenCount: number, parenthesized: Internal.List_<Internal.CastingImage$ParenthesizedIota>, escapeNext: boolean, opsConsumed: number, userData: Internal.CompoundTag_): this;
        static loadFromNbt(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.CastingImage;
        getParenthesized(): Internal.List<Internal.CastingImage$ParenthesizedIota>;
        component4(): boolean;
        getUserData(): Internal.CompoundTag;
        withOverriddenUsedOps(count: number): this;
        component1(): Internal.List<Internal.Iota>;
        static checkAndMarkGivenMotion(userData: Internal.CompoundTag_, entity: Internal.Entity_): boolean;
        withResetEscape(): this;
        static copy$default(arg0: Internal.CastingImage_, arg1: Internal.List_<any>, arg2: number, arg3: Internal.List_<any>, arg4: boolean, arg5: number, arg6: Internal.CompoundTag_, arg7: number, arg8: any): Internal.CastingImage;
        serializeToNbt(): Internal.CompoundTag;
        withUsedOps(count: number): this;
        getStack(): Internal.List<Internal.Iota>;
        getParenCount(): number;
        getOpsConsumed(): number;
        component3(): Internal.List<Internal.CastingImage$ParenthesizedIota>;
        withUsedOp(): this;
        component6(): Internal.CompoundTag;
        getEscapeNext(): boolean;
        get parenthesized(): Internal.List<Internal.CastingImage$ParenthesizedIota>
        get userData(): Internal.CompoundTag
        get stack(): Internal.List<Internal.Iota>
        get parenCount(): number
        get opsConsumed(): number
        get escapeNext(): boolean
        static readonly TAG_PAREN_COUNT: "open_parens";
        static readonly Companion: Internal.CastingImage$Companion;
        static readonly TAG_USERDATA: "userdata";
        static readonly TAG_STACK: "stack";
        static readonly TAG_PARENTHESIZED: "parenthesized";
        static readonly TAG_OPS_CONSUMED: "ops_consumed";
        static readonly TAG_ESCAPE_NEXT: "escape_next";
    }
    type CastingImage_ = CastingImage;
    class SoundBufferLibrary {
        constructor($$0: Internal.ResourceProvider_)
        getStream($$0: ResourceLocation_, $$1: boolean): Internal.CompletableFuture<Internal.AudioStream>;
        preload($$0: Internal.Collection_<Internal.Sound>): Internal.CompletableFuture<any>;
        clear(): void;
        getCompleteBuffer($$0: ResourceLocation_): Internal.CompletableFuture<Internal.SoundBuffer>;
    }
    type SoundBufferLibrary_ = SoundBufferLibrary;
    interface CustomEnchantmentsItem {
        abstract modifyEnchantments(arg0: Internal.Map_<Internal.Enchantment, number>, arg1: Internal.ItemStack_): void;
        (arg0: Internal.Map<Internal.Enchantment, number>, arg1: Internal.ItemStack): void;
    }
    type CustomEnchantmentsItem_ = CustomEnchantmentsItem;
    class PlayerEnderChestContainer extends Internal.SimpleContainer {
        constructor()
        count(ingredient: Internal.Ingredient_): number;
        static tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        isActiveChest($$0: Internal.EnderChestBlockEntity_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        setChanged(): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        setActiveChest($$0: Internal.EnderChestBlockEntity_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get slots(): number
        get height(): number
        set activeChest($$0: Internal.EnderChestBlockEntity_)
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type PlayerEnderChestContainer_ = PlayerEnderChestContainer;
    interface MatrixStackTransformer {
        translate(x: number, y: number, z: number): this;
        scale(x: number, y: number, z: number): this;
        getMatrixStack(): Internal.PoseStack;
        push(): this;
        pop(): this;
        multiplyPositionMatrix(matrix: Matrix4f_): this;
        multiply(quaternion: Quaternionf_, originX: number, originY: number, originZ: number): this;
        translate(x: number, y: number, z: number): this;
        multiply(quaternion: Quaternionf_): this;
        get matrixStack(): Internal.PoseStack
    }
    type MatrixStackTransformer_ = MatrixStackTransformer;
    interface HolderSet <T> extends Internal.Iterable<Internal.Holder<T>> {
        abstract unwrap(): Internal.Either<Internal.TagKey<T>, Internal.List<Internal.Holder<T>>>;
        abstract iterator(): Internal.Iterator<Internal.Holder<T>>;
        abstract unwrapKey(): Internal.Optional<Internal.TagKey<T>>;
        /**
         * @deprecated
        */
        emptyNamed<T>($$0: Internal.HolderOwner_<T>, $$1: Internal.TagKey_<T>): Internal.HolderSet$Named<T>;
        abstract get(arg0: number): Internal.Holder<T>;
        spliterator(): Internal.Spliterator<Internal.Holder<T>>;
        abstract stream(): Internal.Stream<Internal.Holder<T>>;
        abstract canSerializeIn(arg0: Internal.HolderOwner_<T>): boolean;
        abstract size(): number;
        direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, ...$$1: E[]): Internal.HolderSet$Direct<T>;
        abstract contains(arg0: Internal.Holder_<T>): boolean;
        direct<T>(...$$0: Internal.Holder_<T>[]): Internal.HolderSet$Direct<T>;
        forEach(arg0: Internal.Consumer_<Internal.Holder<T>>): void;
        direct<T>($$0: Internal.List_<Internal.Holder<T>>): Internal.HolderSet$Direct<T>;
        abstract getRandomElement(arg0: Internal.RandomSource_): Internal.Optional<Internal.Holder<T>>;
        direct<E, T>($$0: Internal.Function_<E, Internal.Holder<T>>, $$1: Internal.List_<E>): Internal.HolderSet$Direct<T>;
    }
    type HolderSet_<T> = HolderSet<T>;
    class BoilerBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IHaveBigOutline, Internal.IHasCustomOutline, Internal.ReducedDestroyEffects {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        customOutline(poseStack: Internal.PoseStack_, consumer: Internal.VertexConsumer_, state: Internal.BlockState_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        drawLine(vb: Internal.VertexConsumer_, ms: Internal.PoseStack_, x1: number, y1: number, z1: number, x2: number, y2: number, z2: number): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        setRequiresTool(v: boolean): void;
        getShapeForState(state: Internal.BlockState_): Internal.VoxelShape;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        emi(): Internal.EmiStack;
        drawLineWithAxisOffset(vb: Internal.VertexConsumer_, ms: Internal.PoseStack_, x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, offset: number, axis: Internal.Direction$Axis_): void;
        matrixRotation(poseStack: Internal.PoseStack_, state: Internal.BlockState_): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
        static readonly placementHelperId: 22;
        static readonly STYLE: Internal.EnumProperty<Internal.BoilerBlock$Style>;
        static readonly RAISED: Internal.BooleanProperty;
    }
    type BoilerBlock_ = BoilerBlock;
    class WoolCarpetBlock extends Internal.CarpetBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WoolCarpetBlock_ = WoolCarpetBlock;
    class TraderLlama extends Internal.Llama {
        constructor($$0: Internal.EntityType_<Internal.TraderLlama>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        setDespawnDelay($$0: number): void;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getJumpCooldown(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        set despawnDelay($$0: number)
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get jumpCooldown(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type TraderLlama_ = TraderLlama;
    class PistonExtensionPoleBlock extends Internal.WrenchableDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type PistonExtensionPoleBlock_ = PistonExtensionPoleBlock;
    interface ServerScoreboardAccessor {
        abstract getServer(): Internal.MinecraftServer;
        get server(): Internal.MinecraftServer
        (): Internal.MinecraftServer_;
    }
    type ServerScoreboardAccessor_ = ServerScoreboardAccessor;
    abstract class TypeToken <T> extends Internal.TypeCapture<T> implements Internal.Serializable {
        static of<T>(arg0: T): Internal.TypeToken<T>;
        where<X>(arg0: Internal.TypeParameter_<X>, arg1: X): this;
        isPrimitive(): boolean;
        method(arg0: Internal.Method_): Internal.Invokable<T, any>;
        static of(arg0: Internal.Type_): Internal.TypeToken<any>;
        getComponentType(): Internal.TypeToken<any>;
        getTypes(): Internal.TypeToken$TypeSet<>;
        where<X>(arg0: Internal.TypeParameter_<X>, arg1: Internal.TypeToken_<X>): this;
        getRawType(): T;
        resolveType(arg0: Internal.Type_): Internal.TypeToken<any>;
        isSubtypeOf(arg0: Internal.TypeToken_<any>): boolean;
        isSupertypeOf(arg0: Internal.Type_): boolean;
        isArray(): boolean;
        wrap(): this;
        isSubtypeOf(arg0: Internal.Type_): boolean;
        unwrap(): this;
        getSubtype(arg0: typeof any): this;
        getSupertype(arg0: T): this;
        "constructor"(arg0: Internal.Constructor_<any>): Internal.Invokable<T, T>;
        getType(): Internal.Type;
        isSupertypeOf(arg0: Internal.TypeToken_<any>): boolean;
        get primitive(): boolean
        get componentType(): Internal.TypeToken<any>
        get types(): Internal.TypeToken$TypeSet<>
        get rawType(): T
        get array(): boolean
        get type(): Internal.Type
    }
    type TypeToken_<T> = TypeToken<T>;
    interface AccessorEntity {
        abstract setYRot(arg0: number): void;
        abstract getYRot(): number;
        abstract getXRot(): number;
        abstract setXRot(arg0: number): void;
        set YRot(arg0: number)
        get YRot(): number
        get XRot(): number
        set XRot(arg0: number)
    }
    type AccessorEntity_ = AccessorEntity;
    interface IMultiBlockEntityContainer {
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        abstract getMaxWidth(): number;
        abstract removeController(arg0: boolean): void;
        abstract getControllerBE<T extends Internal.BlockEntity & Internal.IMultiBlockEntityContainer>(): T;
        abstract getWidth(): number;
        abstract isController(): boolean;
        abstract setController(arg0: BlockPos_): void;
        setExtraData(data: any): void;
        modifyExtraData(data: any): any;
        abstract getController(): BlockPos;
        abstract getLastKnownPos(): BlockPos;
        abstract preventConnectivityUpdate(): void;
        abstract notifyMultiUpdated(): void;
        getExtraData(): any;
        abstract getMainConnectionAxis(): Internal.Direction$Axis;
        abstract setHeight(arg0: number): void;
        abstract setWidth(arg0: number): void;
        abstract getHeight(): number;
        abstract getMaxLength(arg0: Internal.Direction$Axis_, arg1: number): number;
        get maxWidth(): number
        get controllerBE(): T
        get width(): number
        get controller(): boolean
        set controller(arg0: BlockPos_)
        set extraData(data: any)
        get controller(): BlockPos
        get lastKnownPos(): BlockPos
        get extraData(): any
        get mainConnectionAxis(): Internal.Direction$Axis
        set height(arg0: number)
        set width(arg0: number)
        get height(): number
    }
    type IMultiBlockEntityContainer_ = IMultiBlockEntityContainer;
    interface FadableScreenElement extends Internal.ScreenElement {
        render(graphics: Internal.GuiGraphics_, x: number, y: number): void;
        abstract render(arg0: Internal.GuiGraphics_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.GuiGraphics, arg1: number, arg2: number, arg3: number): void;
    }
    type FadableScreenElement_ = FadableScreenElement;
    class FabricParticleTypes$1 extends Internal.SimpleParticleType {
    }
    type FabricParticleTypes$1_ = FabricParticleTypes$1;
    class SodiumBufferBuilder implements Internal.VertexBufferWriter, Internal.ETFVertexConsumer, Internal.VertexConsumer, Internal.BlockSensitiveBufferBuilder {
        constructor(builder: Internal.ExtendedBufferBuilder_)
        uv2(uv: number): Internal.VertexConsumer;
        color(red: number, green: number, blue: number, alpha: number): Internal.VertexConsumer;
        endVertex(): void;
        color(argb: number): Internal.VertexConsumer;
        etf$getProvider(): Internal.MultiBufferSource;
        normal(x: number, y: number, z: number): Internal.VertexConsumer;
        etf$getRenderLayer(): Internal.RenderType;
        static of(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        overlayCoords(uv: number): Internal.VertexConsumer;
        vertex(x: number, y: number, z: number): Internal.VertexConsumer;
        etf$initETFVertexConsumer(provider: Internal.MultiBufferSource_, renderLayer: Internal.RenderType_): void;
        color($$0: number, $$1: number, $$2: number, $$3: number): Internal.VertexConsumer;
        putBulkData($$0: Internal.PoseStack$Pose_, $$1: Internal.BakedQuad_, $$2: number[], $$3: number, $$4: number, $$5: number, $$6: number[], $$7: number, $$8: boolean): void;
        reset(): void;
        putBulkData($$0: Internal.PoseStack$Pose_, $$1: Internal.BakedQuad_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): void;
        static tryOf(consumer: Internal.VertexConsumer_): Internal.VertexBufferWriter;
        canUseIntrinsics(): boolean;
        overlayCoords(u: number, v: number): Internal.VertexConsumer;
        endBlock(): void;
        getOriginalBufferBuilder(): Internal.BufferBuilder;
        static copyInto(writer: Internal.VertexBufferWriter_, stack: Internal.MemoryStack_, ptr: number, count: number, format: Internal.VertexFormatDescription_): void;
        defaultColor(red: number, green: number, blue: number, alpha: number): void;
        uv2(u: number, v: number): Internal.VertexConsumer;
        normal(matrix: Matrix3f_, x: number, y: number, z: number): Internal.VertexConsumer;
        vertex(x: number, y: number, z: number, red: number, green: number, blue: number, alpha: number, u: number, v: number, overlay: number, light: number, normalX: number, normalY: number, normalZ: number): void;
        etf$getETFTexture(): Internal.ETFTexture;
        vertex(matrix: Matrix4f_, x: number, y: number, z: number): Internal.VertexConsumer;
        push(stack: Internal.MemoryStack_, ptr: number, count: number, format: Internal.VertexFormatDescription_): void;
        uv(u: number, v: number): Internal.VertexConsumer;
        unsetDefaultColor(): void;
        beginBlock(block: number, renderType: number, localPosX: number, localPosY: number, localPosZ: number): void;
        get originalBufferBuilder(): Internal.BufferBuilder
    }
    type SodiumBufferBuilder_ = SodiumBufferBuilder;
    class DepotMountedStorage extends Internal.WrapperMountedItemStorage<any> implements Internal.SyncedMountedStorage {
        static fromDepot(depot: Internal.DepotBlockEntity_): Internal.DepotMountedStorage;
        markClean(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        getItem(): Internal.ItemStack;
        static fromLegacy(nbt: Internal.CompoundTag_): Internal.DepotMountedStorage;
        afterSync(contraption: Internal.Contraption_, localPos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        isDirty(): boolean;
        static asClass<T>(): Internal.Storage<T>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        setItem(stack: Internal.ItemStack_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static empty<T>(): Internal.Storage<T>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        get item(): Internal.ItemStack
        get dirty(): boolean
        set item(stack: Internal.ItemStack_)
        static readonly CODEC: Internal.Codec<Internal.DepotMountedStorage>;
    }
    type DepotMountedStorage_ = DepotMountedStorage;
    class MinecartFurnace extends Internal.AbstractMinecart {
        constructor($$0: Internal.EntityType_<Internal.MinecartFurnace>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        getMaxSpeedOnRail(): number;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        get maxSpeedOnRail(): number
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        xPush: number;
        zPush: number;
    }
    type MinecartFurnace_ = MinecartFurnace;
    interface TypeInfo {
        abstract getTypeName(): string;
        abstract getTypeNamespace(): string;
        abstract isDerivedFrom(arg0: string, arg1: string, arg2: number): boolean;
        get typeName(): string
        get typeNamespace(): string
        readonly DERIVATION_LIST: 8;
        readonly DERIVATION_RESTRICTION: 1;
        readonly DERIVATION_EXTENSION: 2;
        readonly DERIVATION_UNION: 4;
    }
    type TypeInfo_ = TypeInfo;
    interface Hopper extends net.minecraft.world.Container {
        stopOpen($$0: Internal.Player_): void;
        tryClear($$0: any): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        abstract removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        abstract setChanged(): void;
        abstract getContainerSize(): number;
        abstract setItem(arg0: number, arg1: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        abstract removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        getSuckShape(): Internal.VoxelShape;
        abstract getItem(arg0: number): Internal.ItemStack;
        abstract getLevelY(): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        abstract isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        abstract getLevelX(): number;
        abstract getLevelZ(): number;
        abstract clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        get suckShape(): Internal.VoxelShape
        get levelY(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        get levelX(): number
        get levelZ(): number
        readonly SUCK: Internal.ArrayVoxelShape;
        readonly INSIDE: Internal.VoxelShapeSimpleCube;
        readonly ABOVE: Internal.VoxelShapeSimpleCube;
    }
    type Hopper_ = Hopper;
    class DeltaFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockState_, $$1: Internal.BlockState_, $$2: Internal.IntProvider_, $$3: Internal.IntProvider_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        rim(): Internal.BlockState;
        rimSize(): Internal.IntProvider;
        contents(): Internal.BlockState;
        size(): Internal.IntProvider;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.DeltaFeatureConfiguration>;
    }
    type DeltaFeatureConfiguration_ = DeltaFeatureConfiguration;
    interface AccessorShapedRecipe {
        bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        bookshelf$shrink(...pattern: string[]): string[];
        bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
    }
    type AccessorShapedRecipe_ = AccessorShapedRecipe;
    class RecipeProperties extends Internal.Record {
        constructor(group: string, category: Internal.CraftingBookCategory_)
        category(): Internal.CraftingBookCategory;
        static fromJson(json: Internal.JsonObject_): Internal.RecipeProperties;
        static fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.RecipeProperties;
        group(): string;
        toNetwork(buffer: Internal.FriendlyByteBuf_): void;
        static of(recipe: Internal.CraftingRecipe_): Internal.RecipeProperties;
    }
    type RecipeProperties_ = RecipeProperties;
    class InvisibleMonoBogeyBlockEntity extends Internal.MonoBogeyBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type InvisibleMonoBogeyBlockEntity_ = InvisibleMonoBogeyBlockEntity;
    class HolderSetCodec <E> implements Internal.Codec<Internal.HolderSet<E>> {
        orElse(arg0: Internal.HolderSet_<E>): Internal.Codec<Internal.HolderSet<E>>;
        flatMap<B>(arg0: Internal.Function_<Internal.HolderSet<E>, Internal.DataResult<B>>): Internal.Decoder<B>;
        decode<T>($$0: Internal.DynamicOps_<T>, $$1: T): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.HolderSet<E>, T>>;
        static empty<A>(): Internal.MapEncoder<A>;
        static error<A>(arg0: string): Internal.Encoder<A>;
        static unit<A>(arg0: Internal.Supplier_<A>): Internal.Codec<A>;
        static create<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>, $$1: Internal.Codec_<Internal.Holder<E>>, $$2: boolean): Internal.Codec<Internal.HolderSet<E>>;
        dispatch<E>(arg0: Internal.Function_<E, Internal.HolderSet<E>>, arg1: Internal.Function_<Internal.HolderSet<E>, Internal.Codec<E>>): Internal.Codec<E>;
        flatXmap<S>(arg0: Internal.Function_<Internal.HolderSet<E>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.DataResult<Internal.HolderSet<E>>>): Internal.Codec<S>;
        static floatRange(arg0: number, arg1: number): Internal.Codec<number>;
        map<B>(arg0: Internal.Function_<Internal.HolderSet<E>, B>): Internal.Decoder<B>;
        mapResult(arg0: Internal.Codec$ResultFunction_<Internal.HolderSet<E>>): Internal.Codec<Internal.HolderSet<E>>;
        orElse(arg0: Internal.Consumer_<string>, arg1: Internal.HolderSet_<E>): Internal.Codec<Internal.HolderSet<E>>;
        orElseGet(arg0: Internal.UnaryOperator_<string>, arg1: Internal.Supplier_<Internal.HolderSet<E>>): Internal.Codec<Internal.HolderSet<E>>;
        optionalFieldOf(arg0: string, arg1: Internal.Lifecycle_, arg2: Internal.HolderSet_<E>, arg3: Internal.Lifecycle_): Internal.MapCodec<Internal.HolderSet<E>>;
        static ofBoxed<A>(arg0: Internal.Decoder$Boxed_<A>): Internal.Decoder<A>;
        deprecated(arg0: number): Internal.Codec<Internal.HolderSet<E>>;
        terminal(): Internal.Decoder$Terminal<Internal.HolderSet<E>>;
        partialDispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.DataResult<Internal.HolderSet<E>>>, arg2: Internal.Function_<Internal.HolderSet<E>, Internal.DataResult<Internal.Codec<E>>>): Internal.Codec<E>;
        parse<T>(arg0: Internal.DynamicOps_<T>, arg1: T): Internal.DataResult<Internal.HolderSet<E>>;
        comap<B>(arg0: Internal.Function_<B, Internal.HolderSet<E>>): Internal.Encoder<B>;
        orElseGet(arg0: Internal.Supplier_<Internal.HolderSet<E>>): Internal.Codec<Internal.HolderSet<E>>;
        dispatchStable<E>(arg0: Internal.Function_<E, Internal.HolderSet<E>>, arg1: Internal.Function_<Internal.HolderSet<E>, Internal.Codec<E>>): Internal.Codec<E>;
        static unit<A>(arg0: A): Internal.Codec<A>;
        static intRange(arg0: number, arg1: number): Internal.Codec<number>;
        static pair<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<com.mojang.datafixers.util.Pair<F, S>>;
        static either<F, S>(arg0: Internal.Codec_<F>, arg1: Internal.Codec_<S>): Internal.Codec<Internal.Either<F, S>>;
        static checkRange<N extends number & Internal.Comparable<N>>(arg0: N, arg1: N): Internal.Function<N, Internal.DataResult<N>>;
        dispatchMap<E>(arg0: Internal.Function_<E, Internal.HolderSet<E>>, arg1: Internal.Function_<Internal.HolderSet<E>, Internal.Codec<E>>): Internal.MapCodec<E>;
        stable(): Internal.Codec<Internal.HolderSet<E>>;
        withLifecycle(arg0: Internal.Lifecycle_): Internal.Codec<Internal.HolderSet<E>>;
        static unboundedMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.UnboundedMapCodec<K, V>;
        promotePartial(arg0: Internal.Consumer_<string>): Internal.Codec<Internal.HolderSet<E>>;
        xmap<S>(arg0: Internal.Function_<Internal.HolderSet<E>, S>, arg1: Internal.Function_<S, Internal.HolderSet<E>>): Internal.Codec<S>;
        fieldOf(arg0: string): Internal.MapDecoder<any>;
        dispatchMap<E>(arg0: string, arg1: Internal.Function_<E, Internal.HolderSet<E>>, arg2: Internal.Function_<Internal.HolderSet<E>, Internal.Codec<E>>): Internal.MapCodec<E>;
        parse<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<Internal.HolderSet<E>>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>, arg2: string): Internal.Codec<A>;
        decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<com.mojang.datafixers.util.Pair<Internal.HolderSet<E>, T>>;
        optionalFieldOf(arg0: string, arg1: Internal.HolderSet_<E>): Internal.MapCodec<Internal.HolderSet<E>>;
        static ofSimple<A>(arg0: Internal.Decoder$Simple_<A>): Internal.Decoder<A>;
        static mapEither<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<Internal.Either<F, S>>;
        static doubleRange(arg0: number, arg1: number): Internal.Codec<number>;
        orElseGet(arg0: Internal.Consumer_<string>, arg1: Internal.Supplier_<Internal.HolderSet<E>>): Internal.Codec<Internal.HolderSet<E>>;
        static optionalField<F>(arg0: string, arg1: Internal.Codec_<F>): Internal.MapCodec<Internal.Optional<F>>;
        static simpleMap<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>, arg2: Internal.Keyable_): Internal.SimpleMapCodec<K, V>;
        static ofTerminal<A>(arg0: Internal.Decoder$Terminal_<A>): Internal.Decoder<A>;
        encode(arg0: any, arg1: Internal.DynamicOps_<any>, arg2: any): Internal.DataResult<any>;
        dispatch<E>(arg0: string, arg1: Internal.Function_<E, Internal.HolderSet<E>>, arg2: Internal.Function_<Internal.HolderSet<E>, Internal.Codec<E>>): Internal.Codec<E>;
        orElse(arg0: Internal.UnaryOperator_<string>, arg1: Internal.HolderSet_<E>): Internal.Codec<Internal.HolderSet<E>>;
        static list<E>(arg0: Internal.Codec_<E>): Internal.Codec<Internal.List<E>>;
        optionalFieldOf(arg0: string, arg1: Internal.HolderSet_<E>, arg2: Internal.Lifecycle_): Internal.MapCodec<Internal.HolderSet<E>>;
        simple(): Internal.Decoder$Simple<Internal.HolderSet<E>>;
        optionalFieldOf(arg0: string): Internal.MapCodec<Internal.Optional<Internal.HolderSet<E>>>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>): Internal.MapCodec<A>;
        comapFlatMap<S>(arg0: Internal.Function_<Internal.HolderSet<E>, Internal.DataResult<S>>, arg1: Internal.Function_<S, Internal.HolderSet<E>>): Internal.Codec<S>;
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<Internal.HolderSet<E>>>): Internal.Encoder<B>;
        static of<A>(arg0: Internal.Encoder_<A>, arg1: Internal.Decoder_<A>): Internal.Codec<A>;
        boxed(): Internal.Decoder$Boxed<Internal.HolderSet<E>>;
        static of<A>(arg0: Internal.MapEncoder_<A>, arg1: Internal.MapDecoder_<A>, arg2: Internal.Supplier_<string>): Internal.MapCodec<A>;
        static compoundList<K, V>(arg0: Internal.Codec_<K>, arg1: Internal.Codec_<V>): Internal.Codec<Internal.List<com.mojang.datafixers.util.Pair<K, V>>>;
        listOf(): Internal.Codec<Internal.List<Internal.HolderSet<E>>>;
        encode<T>($$0: Internal.HolderSet_<E>, $$1: Internal.DynamicOps_<T>, $$2: T): Internal.DataResult<T>;
        encodeStart<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.HolderSet_<E>): Internal.DataResult<T>;
        flatComapMap<S>(arg0: Internal.Function_<Internal.HolderSet<E>, S>, arg1: Internal.Function_<S, Internal.DataResult<Internal.HolderSet<E>>>): Internal.Codec<S>;
        static mapPair<F, S>(arg0: Internal.MapCodec_<F>, arg1: Internal.MapCodec_<S>): Internal.MapCodec<com.mojang.datafixers.util.Pair<F, S>>;
    }
    type HolderSetCodec_<E> = HolderSetCodec<E>;
    interface GlyphInfo {
        getAdvance($$0: boolean): number;
        abstract getAdvance(): number;
        getBoldOffset(): number;
        abstract bake(arg0: Internal.Function_<Internal.SheetGlyphInfo, Internal.BakedGlyph>): Internal.BakedGlyph;
        getShadowOffset(): number;
        get advance(): number
        get boldOffset(): number
        get shadowOffset(): number
    }
    type GlyphInfo_ = GlyphInfo;
    interface TaskChainer$DelayedTask {
        abstract submit(arg0: Internal.Executor_): Internal.CompletableFuture<any>;
        (arg0: Internal.Executor): Internal.CompletableFuture_<any>;
    }
    type TaskChainer$DelayedTask_ = TaskChainer$DelayedTask;
    interface GenericFutureListener <F extends io.netty.util.concurrent.Future<any>> extends Internal.EventListener {
        abstract operationComplete(arg0: F): void;
        (arg0: F): void;
    }
    type GenericFutureListener_<F extends io.netty.util.concurrent.Future<any>> = GenericFutureListener<F>;
    class Action$Companion {
        makeConstantOp(x: Internal.Iota_): Internal.Action;
        getDOUBLE_FORMATTER(): Internal.DecimalFormat;
        raycastEnd(origin: Vec3d_, look: Vec3d_): Vec3d;
        get DOUBLE_FORMATTER(): Internal.DecimalFormat
        static readonly RAYCAST_DISTANCE: 32.0;
    }
    type Action$Companion_ = Action$Companion;
    interface TeamAccessor {
        abstract getScoreboard(): Internal.Scoreboard;
        get scoreboard(): Internal.Scoreboard
        (): Internal.Scoreboard_;
    }
    type TeamAccessor_ = TeamAccessor;
    class ProcessingPatternItem extends Internal.EncodedPatternItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        encode(sparseInputs: Internal.GenericStack_[], sparseOutputs: Internal.GenericStack_[]): Internal.ItemStack;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ProcessingPatternItem_ = ProcessingPatternItem;
    class ServerGamePacketListenerImpl implements io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.ServerGamePacketListenerImplAccessor, Internal.ServerPlayerConnection, Internal.NetworkHandlerExtensions, Internal.DisconnectPacketSource, Internal.ServerGamePacketListener, Internal.ServerPlayNetworkHandlerAccessor, Internal.TickablePacketListener, net.fabricmc.fabric.mixin.networking.accessor.ServerPlayNetworkHandlerAccessor, Internal.ServerGamePacketListenerImplAccessor {
        constructor($$0: Internal.MinecraftServer_, $$1: Internal.Connection_, $$2: Internal.ServerPlayer_)
        createDisconnectPacket(message: net.minecraft.network.chat.Component_): Internal.Packet<any>;
        handleChatCommand($$0: Internal.ServerboundChatCommandPacket_): void;
        sendPlayerChatMessage($$0: Internal.PlayerChatMessage_, $$1: Internal.ChatType$Bound_): void;
        handlePlayerAbilities($$0: Internal.ServerboundPlayerAbilitiesPacket_): void;
        handlePlayerInput($$0: Internal.ServerboundPlayerInputPacket_): void;
        handleClientCommand($$0: Internal.ServerboundClientCommandPacket_): void;
        constant$hjp000$trinkets$modifyCreativeSlotMax(value: number): number;
        handleResourcePackResponse($$0: Internal.ServerboundResourcePackPacket_): void;
        handleSetCarriedItem($$0: Internal.ServerboundSetCarriedItemPacket_): void;
        handlePickItem($$0: Internal.ServerboundPickItemPacket_): void;
        handleSetCreativeModeSlot($$0: Internal.ServerboundSetCreativeModeSlotPacket_): void;
        handleSeenAdvancements($$0: Internal.ServerboundSeenAdvancementsPacket_): void;
        getPlayer(): Internal.ServerPlayer;
        handleKeepAlive($$0: Internal.ServerboundKeepAlivePacket_): void;
        handleUseItem($$0: Internal.ServerboundUseItemPacket_): void;
        handlePaddleBoat($$0: Internal.ServerboundPaddleBoatPacket_): void;
        handleSetStructureBlock($$0: Internal.ServerboundSetStructureBlockPacket_): void;
        handleCustomPayload($$0: Internal.ServerboundCustomPayloadPacket_): void;
        send($$0: Internal.Packet_<any>, $$1: Internal.PacketSendListener_): void;
        handleSelectTrade($$0: Internal.ServerboundSelectTradePacket_): void;
        handleJigsawGenerate($$0: Internal.ServerboundJigsawGeneratePacket_): void;
        ackBlockChangesUpTo($$0: number): void;
        getConnection(): Internal.Connection;
        onDisconnect($$0: net.minecraft.network.chat.Component_): void;
        handleSetJigsawBlock($$0: Internal.ServerboundSetJigsawBlockPacket_): void;
        create$setAboveGroundTickCount(arg0: number): void;
        handleSetCommandMinecart($$0: Internal.ServerboundSetCommandMinecartPacket_): void;
        tick(): void;
        getRemoteAddress(): Internal.SocketAddress;
        handler$zid001$ad_astra$adastra$tick(ci: Internal.CallbackInfo_): void;
        handleSetCommandBlock($$0: Internal.ServerboundSetCommandBlockPacket_): void;
        handleRecipeBookSeenRecipePacket($$0: Internal.ServerboundRecipeBookSeenRecipePacket_): void;
        handleBlockEntityTagQuery($$0: Internal.ServerboundBlockEntityTagQuery_): void;
        handleChatSessionUpdate($$0: Internal.ServerboundChatSessionUpdatePacket_): void;
        port_lib$setAboveGroundTickCount(arg0: number): void;
        handleContainerButtonClick($$0: Internal.ServerboundContainerButtonClickPacket_): void;
        handlePong($$0: Internal.ServerboundPongPacket_): void;
        teleport($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        filterTextPacket($$0: Internal.List_<string>): Internal.CompletableFuture<Internal.List<Internal.FilteredText>>;
        getAddon(): Internal.AbstractNetworkAddon<any>;
        handlePlaceRecipe($$0: Internal.ServerboundPlaceRecipePacket_): void;
        handlePlayerCommand($$0: Internal.ServerboundPlayerCommandPacket_): void;
        handleEditBook($$0: Internal.ServerboundEditBookPacket_): void;
        sendDisguisedChatMessage($$0: net.minecraft.network.chat.Component_, $$1: Internal.ChatType$Bound_): void;
        handleTeleportToEntityPacket($$0: Internal.ServerboundTeleportToEntityPacket_): void;
        handleInteract($$0: Internal.ServerboundInteractPacket_): void;
        create$setAboveGroundVehicleTickCount(arg0: number): void;
        handleContainerClose($$0: Internal.ServerboundContainerClosePacket_): void;
        handleChangeDifficulty($$0: Internal.ServerboundChangeDifficultyPacket_): void;
        handleClientInformation($$0: Internal.ServerboundClientInformationPacket_): void;
        addPendingMessage($$0: Internal.PlayerChatMessage_): void;
        handleRecipeBookChangeSettingsPacket($$0: Internal.ServerboundRecipeBookChangeSettingsPacket_): void;
        isAcceptingMessages(): boolean;
        handleContainerClick($$0: Internal.ServerboundContainerClickPacket_): void;
        handleCustomCommandSuggestions($$0: Internal.ServerboundCommandSuggestionPacket_): void;
        handleAcceptTeleportPacket($$0: Internal.ServerboundAcceptTeleportationPacket_): void;
        handleMovePlayer($$0: Internal.ServerboundMovePlayerPacket_): void;
        handleChatAck($$0: Internal.ServerboundChatAckPacket_): void;
        disconnect($$0: net.minecraft.network.chat.Component_): void;
        owo$getConnection(): Internal.Connection;
        handlePlayerAction($$0: Internal.ServerboundPlayerActionPacket_): void;
        resetPosition(): void;
        handleLockDifficulty($$0: Internal.ServerboundLockDifficultyPacket_): void;
        handleAnimate($$0: Internal.ServerboundSwingPacket_): void;
        handleRenameItem($$0: Internal.ServerboundRenameItemPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        handleEntityTagQuery($$0: Internal.ServerboundEntityTagQuery_): void;
        handleSignUpdate($$0: Internal.ServerboundSignUpdatePacket_): void;
        handleChat($$0: Internal.ServerboundChatPacket_): void;
        teleport($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: Internal.Set_<Internal.RelativeMovement>): void;
        handleSetBeaconPacket($$0: Internal.ServerboundSetBeaconPacket_): void;
        handleUseItemOn($$0: Internal.ServerboundUseItemOnPacket_): void;
        send($$0: Internal.Packet_<any>): void;
        handleMoveVehicle($$0: Internal.ServerboundMoveVehiclePacket_): void;
        get player(): Internal.ServerPlayer
        get connection(): Internal.Connection
        get remoteAddress(): Internal.SocketAddress
        get addon(): Internal.AbstractNetworkAddon<any>
        get acceptingMessages(): boolean
        aboveGroundVehicleTickCount: number;
        aboveGroundTickCount: number;
        readonly connection: Internal.Connection;
        static readonly MAX_INTERACTION_DISTANCE: 36.0;
        player: Internal.ServerPlayer;
    }
    type ServerGamePacketListenerImpl_ = ServerGamePacketListenerImpl;
    class NoiseThresholdProvider extends Internal.NoiseBasedStateProvider {
        constructor($$0: number, $$1: Internal.NormalNoise$NoiseParameters_, $$2: number, $$3: number, $$4: number, $$5: Internal.BlockState_, $$6: Internal.List_<Internal.BlockState>, $$7: Internal.List_<Internal.BlockState>)
        static readonly CODEC: Internal.Codec<Internal.NoiseThresholdProvider>;
    }
    type NoiseThresholdProvider_ = NoiseThresholdProvider;
    class MonoTrackBufferBlock$Style extends Internal.Enum<Internal.MonoTrackBufferBlock$Style> implements Internal.StringRepresentable {
        getModel(): ResourceLocation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.MonoTrackBufferBlock$Style;
        getSerializedName(): string;
        static values(): Internal.MonoTrackBufferBlock$Style[];
        get model(): ResourceLocation
        get serializedName(): string
        static readonly SIDE: Internal.MonoTrackBufferBlock$Style;
        static readonly MONO: Internal.MonoTrackBufferBlock$Style;
        static readonly STANDARD: Internal.MonoTrackBufferBlock$Style;
    }
    type MonoTrackBufferBlock$Style_ = "side" | "standard" | "mono" | MonoTrackBufferBlock$Style;
    class Sheep extends Internal.Animal implements Internal.Shearable, Internal.IShearable {
        constructor($$0: Internal.EntityType_<Internal.Sheep>, $$1: Internal.Level_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        getColor(): Internal.DyeColor;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        readyForShearing(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        method_5991(): ResourceLocation;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getHeadEatAngleScale($$0: number): number;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        static getColorArray($$0: Internal.DyeColor_): number[];
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<any>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setColor($$0: Internal.DyeColor_): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setSheared($$0: boolean): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        shear($$0: Internal.SoundSource_): void;
        getHeadEatPositionScale($$0: number): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        isSheared(): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        static getRandomSheepColor($$0: Internal.RandomSource_): Internal.DyeColor;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get color(): Internal.DyeColor
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set color($$0: Internal.DyeColor_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set sheared($$0: boolean)
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get sheared(): boolean
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Sheep_ = Sheep;
    class AttributeKey <T> extends Internal.AbstractConstant<Internal.AttributeKey<T>> {
        static valueOf<T>(arg0: string): Internal.AttributeKey<T>;
        static newInstance<T>(arg0: string): Internal.AttributeKey<T>;
        static valueOf<T>(arg0: typeof any, arg1: string): Internal.AttributeKey<T>;
        static exists(arg0: string): boolean;
    }
    type AttributeKey_<T> = AttributeKey<T>;
    class FishingRodItem extends Internal.Item implements Internal.Vanishable, Internal.VanillaToolActionItem {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        port_lib$canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FishingRodItem_ = FishingRodItem;
    class TravellingPoint {
        constructor()
        constructor(node1: Internal.TrackNode_, node2: Internal.TrackNode_, edge: Internal.TrackEdge_, position: number, upsideDown: boolean)
        ignoreEdgePoints(): Internal.TravellingPoint$IEdgePointListener;
        travel(graph: Internal.TrackGraph_, distance: number, trackSelector: Internal.TravellingPoint$ITrackSelector_): number;
        getPositionWithOffset(trackGraph: Internal.TrackGraph_, offset: number, flipUpsideDown: boolean): Vec3d;
        static read(tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.TravellingPoint;
        follow(other: Internal.TravellingPoint_): Internal.TravellingPoint$ITrackSelector;
        travel(graph: Internal.TrackGraph_, distance: number, trackSelector: Internal.TravellingPoint$ITrackSelector_, signalListener: Internal.TravellingPoint$IEdgePointListener_, turnListener: Internal.TravellingPoint$ITurnListener_): number;
        random(): Internal.TravellingPoint$ITrackSelector;
        follow(other: Internal.TravellingPoint_, success: Internal.Consumer_<boolean>): Internal.TravellingPoint$ITrackSelector;
        getPosition(trackGraph: Internal.TrackGraph_, flipUpsideDown: boolean): Vec3d;
        ignorePortals(): Internal.TravellingPoint$IPortalListener;
        travel(graph: Internal.TrackGraph_, distance: number, trackSelector: Internal.TravellingPoint$ITrackSelector_, signalListener: Internal.TravellingPoint$IEdgePointListener_, turnListener: Internal.TravellingPoint$ITurnListener_, portalListener: Internal.TravellingPoint$IPortalListener_): number;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        reverse(graph: Internal.TrackGraph_): void;
        steer(direction: Internal.TravellingPoint$SteerDirection_, upNormal: Vec3d_): Internal.TravellingPoint$ITrackSelector;
        travel(graph: Internal.TrackGraph_, distance: number, trackSelector: Internal.TravellingPoint$ITrackSelector_, signalListener: Internal.TravellingPoint$IEdgePointListener_): number;
        migrateTo(locations: Internal.List_<Internal.TrackGraphLocation>): void;
        getPosition(trackGraph: Internal.TrackGraph_): Vec3d;
        ignoreTurns(): Internal.TravellingPoint$ITurnListener;
        position: number;
        blocked: boolean;
        upsideDown: boolean;
        node1: Internal.TrackNode;
        node2: Internal.TrackNode;
        edge: Internal.TrackEdge;
    }
    type TravellingPoint_ = TravellingPoint;
    class OceanRuinStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_, $$1: Internal.OceanRuinStructure$Type_, $$2: number, $$3: number)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        readonly biomeTemp: Internal.OceanRuinStructure$Type;
        static readonly CODEC: Internal.Codec<Internal.OceanRuinStructure>;
        readonly clusterProbability: number;
        readonly largeProbability: number;
    }
    type OceanRuinStructure_ = OceanRuinStructure;
    class BlockRotProcessor extends Internal.StructureProcessor {
        constructor($$0: Internal.HolderSet_<Internal.Block>, $$1: number)
        constructor($$0: number)
        static readonly CODEC: Internal.Codec<Internal.BlockRotProcessor>;
    }
    type BlockRotProcessor_ = BlockRotProcessor;
    interface BooleanValueInvoker {
        invokeCreate(defaultValue: boolean, onChanged: Internal.BiConsumer_<Internal.MinecraftServer, Internal.GameRules$BooleanValue>): Internal.GameRules$Type<Internal.GameRules$BooleanValue>;
    }
    type BooleanValueInvoker_ = BooleanValueInvoker;
    class LootItemConditionType extends Internal.SerializerType<Internal.LootItemCondition> {
        constructor($$0: Internal.Serializer_<Internal.LootItemCondition>)
    }
    type LootItemConditionType_ = LootItemConditionType | Special.LootConditionType;
    class RedMapleLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type RedMapleLeavesBlock_ = RedMapleLeavesBlock;
    class LastSeenMessages$Packed extends Internal.Record {
        constructor($$0: Internal.List_<Internal.MessageSignature$Packed>)
        constructor($$0: Internal.FriendlyByteBuf_)
        entries(): Internal.List<Internal.MessageSignature$Packed>;
        write($$0: Internal.FriendlyByteBuf_): void;
        unpack($$0: Internal.MessageSignatureCache_): Internal.Optional<Internal.LastSeenMessages>;
        static readonly EMPTY: Internal.LastSeenMessages$Packed;
    }
    type LastSeenMessages$Packed_ = LastSeenMessages$Packed;
    interface ILuaCallback {
        abstract resume(arg0: any[]): Internal.MethodResult;
        (arg0: any[]): Internal.MethodResult_;
    }
    type ILuaCallback_ = ILuaCallback;
    class BrimstoneFumaroleBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BrimstoneFumaroleBlock_ = BrimstoneFumaroleBlock;
    interface FabricDataGenerator$Pack$Factory <T extends Internal.DataProvider> {
        abstract create(arg0: Internal.FabricDataOutput_): T;
        (arg0: Internal.FabricDataOutput): T;
    }
    type FabricDataGenerator$Pack$Factory_<T extends Internal.DataProvider> = FabricDataGenerator$Pack$Factory<T>;
    abstract class TypeAdapter <T> {
        constructor()
        toJsonTree(arg0: T): Internal.JsonElement;
        fromJsonTree(arg0: Internal.JsonElement_): T;
        abstract write(arg0: Internal.JsonWriter_, arg1: T): void;
        nullSafe(): this;
        toJson(arg0: Internal.Writer_, arg1: T): void;
        abstract read(arg0: Internal.JsonReader_): T;
        fromJson(arg0: string): T;
        fromJson(arg0: Internal.Reader_): T;
        toJson(arg0: T): string;
    }
    type TypeAdapter_<T> = TypeAdapter<T>;
    interface IFlyingMount {
        fliesLikeElytra(): boolean;
        getYSpeedMod(): number;
        abstract getRidingPlayer(): Internal.Player;
        abstract getFlightSpeedModifier(): number;
        isGoingDown(): boolean;
        isHovering(): boolean;
        isGoingUp(): boolean;
        abstract isFlying(): boolean;
        get YSpeedMod(): number
        get ridingPlayer(): Internal.Player
        get flightSpeedModifier(): number
        get goingDown(): boolean
        get hovering(): boolean
        get goingUp(): boolean
        get flying(): boolean
    }
    type IFlyingMount_ = IFlyingMount;
    interface IAnimation {
        abstract setupAnim(arg0: number): void;
        abstract get3DTransform(arg0: string, arg1: Internal.TransformType_, arg2: number, arg3: Internal.Vec3f_): Internal.Vec3f;
        abstract isActive(): boolean;
        getFirstPersonConfiguration(tickDelta: number): Internal.FirstPersonConfiguration;
        tick(): void;
        getFirstPersonMode(tickDelta: number): Internal.FirstPersonMode;
        set upAnim(arg0: number)
        get active(): boolean
    }
    type IAnimation_ = IAnimation;
    interface ClientGamePacketListener extends Internal.PacketListener {
        abstract setActionBarText(arg0: Internal.ClientboundSetActionBarTextPacket_): void;
        abstract handleContainerSetSlot(arg0: Internal.ClientboundContainerSetSlotPacket_): void;
        abstract handleAddPlayer(arg0: Internal.ClientboundAddPlayerPacket_): void;
        abstract handleSetScore(arg0: Internal.ClientboundSetScorePacket_): void;
        abstract handleAnimate(arg0: Internal.ClientboundAnimatePacket_): void;
        abstract handlePlayerInfoRemove(arg0: Internal.ClientboundPlayerInfoRemovePacket_): void;
        abstract handleResourcePack(arg0: Internal.ClientboundResourcePackPacket_): void;
        abstract handleContainerContent(arg0: Internal.ClientboundContainerSetContentPacket_): void;
        abstract handleOpenScreen(arg0: Internal.ClientboundOpenScreenPacket_): void;
        abstract handleLogin(arg0: Internal.ClientboundLoginPacket_): void;
        abstract handleTagQueryPacket(arg0: Internal.ClientboundTagQueryPacket_): void;
        abstract onDisconnect(arg0: net.minecraft.network.chat.Component_): void;
        abstract handleUpdateAttributes(arg0: Internal.ClientboundUpdateAttributesPacket_): void;
        abstract handleSetSpawn(arg0: Internal.ClientboundSetDefaultSpawnPositionPacket_): void;
        abstract handleCustomPayload(arg0: Internal.ClientboundCustomPayloadPacket_): void;
        abstract handleLookAt(arg0: Internal.ClientboundPlayerLookAtPacket_): void;
        abstract handlePlayerInfoUpdate(arg0: Internal.ClientboundPlayerInfoUpdatePacket_): void;
        abstract handleParticleEvent(arg0: Internal.ClientboundLevelParticlesPacket_): void;
        abstract handleHurtAnimation(arg0: Internal.ClientboundHurtAnimationPacket_): void;
        abstract handleTitlesClear(arg0: Internal.ClientboundClearTitlesPacket_): void;
        abstract handleCustomChatCompletions(arg0: Internal.ClientboundCustomChatCompletionsPacket_): void;
        abstract handleContainerClose(arg0: Internal.ClientboundContainerClosePacket_): void;
        abstract handleRemoveEntities(arg0: Internal.ClientboundRemoveEntitiesPacket_): void;
        abstract handleSetCamera(arg0: Internal.ClientboundSetCameraPacket_): void;
        abstract handlePlayerCombatEnter(arg0: Internal.ClientboundPlayerCombatEnterPacket_): void;
        abstract handleTeleportEntity(arg0: Internal.ClientboundTeleportEntityPacket_): void;
        abstract handleForgetLevelChunk(arg0: Internal.ClientboundForgetLevelChunkPacket_): void;
        abstract handleBlockEvent(arg0: Internal.ClientboundBlockEventPacket_): void;
        abstract handleLightUpdatePacket(arg0: Internal.ClientboundLightUpdatePacket_): void;
        abstract handleMoveVehicle(arg0: Internal.ClientboundMoveVehiclePacket_): void;
        abstract handleCommands(arg0: Internal.ClientboundCommandsPacket_): void;
        abstract handleSetBorderCenter(arg0: Internal.ClientboundSetBorderCenterPacket_): void;
        abstract handleItemCooldown(arg0: Internal.ClientboundCooldownPacket_): void;
        abstract handleAddExperienceOrb(arg0: Internal.ClientboundAddExperienceOrbPacket_): void;
        abstract setSubtitleText(arg0: Internal.ClientboundSetSubtitleTextPacket_): void;
        abstract handleRespawn(arg0: Internal.ClientboundRespawnPacket_): void;
        abstract handleCommandSuggestions(arg0: Internal.ClientboundCommandSuggestionsPacket_): void;
        abstract handleSetEquipment(arg0: Internal.ClientboundSetEquipmentPacket_): void;
        abstract handleChunkBlocksUpdate(arg0: Internal.ClientboundSectionBlocksUpdatePacket_): void;
        abstract handleBlockChangedAck(arg0: Internal.ClientboundBlockChangedAckPacket_): void;
        abstract handleExplosion(arg0: Internal.ClientboundExplodePacket_): void;
        abstract handleUpdateMobEffect(arg0: Internal.ClientboundUpdateMobEffectPacket_): void;
        abstract handleKeepAlive(arg0: Internal.ClientboundKeepAlivePacket_): void;
        abstract handleUpdateRecipes(arg0: Internal.ClientboundUpdateRecipesPacket_): void;
        abstract handleLevelChunkWithLight(arg0: Internal.ClientboundLevelChunkWithLightPacket_): void;
        abstract handleOpenBook(arg0: Internal.ClientboundOpenBookPacket_): void;
        abstract handleBlockEntityData(arg0: Internal.ClientboundBlockEntityDataPacket_): void;
        abstract handleUpdateAdvancementsPacket(arg0: Internal.ClientboundUpdateAdvancementsPacket_): void;
        abstract handleBundlePacket(arg0: Internal.ClientboundBundlePacket_): void;
        abstract handleSetChunkCacheRadius(arg0: Internal.ClientboundSetChunkCacheRadiusPacket_): void;
        abstract handleMapItemData(arg0: Internal.ClientboundMapItemDataPacket_): void;
        abstract handleInitializeBorder(arg0: Internal.ClientboundInitializeBorderPacket_): void;
        abstract handleSetPlayerTeamPacket(arg0: Internal.ClientboundSetPlayerTeamPacket_): void;
        abstract handleBlockDestruction(arg0: Internal.ClientboundBlockDestructionPacket_): void;
        abstract handleTakeItemEntity(arg0: Internal.ClientboundTakeItemEntityPacket_): void;
        abstract handleServerData(arg0: Internal.ClientboundServerDataPacket_): void;
        abstract handleEntityLinkPacket(arg0: Internal.ClientboundSetEntityLinkPacket_): void;
        abstract handlePlayerChat(arg0: Internal.ClientboundPlayerChatPacket_): void;
        abstract handleSetBorderSize(arg0: Internal.ClientboundSetBorderSizePacket_): void;
        abstract handleSetTime(arg0: Internal.ClientboundSetTimePacket_): void;
        abstract handleSetCarriedItem(arg0: Internal.ClientboundSetCarriedItemPacket_): void;
        abstract setTitlesAnimation(arg0: Internal.ClientboundSetTitlesAnimationPacket_): void;
        abstract handleDamageEvent(arg0: Internal.ClientboundDamageEventPacket_): void;
        abstract handleSetBorderLerpSize(arg0: Internal.ClientboundSetBorderLerpSizePacket_): void;
        abstract handleSetExperience(arg0: Internal.ClientboundSetExperiencePacket_): void;
        abstract handleSetDisplayObjective(arg0: Internal.ClientboundSetDisplayObjectivePacket_): void;
        abstract handleChunksBiomes(arg0: Internal.ClientboundChunksBiomesPacket_): void;
        abstract handleDisconnect(arg0: Internal.ClientboundDisconnectPacket_): void;
        abstract handleSetHealth(arg0: Internal.ClientboundSetHealthPacket_): void;
        abstract handleTabListCustomisation(arg0: Internal.ClientboundTabListPacket_): void;
        abstract handleAddObjective(arg0: Internal.ClientboundSetObjectivePacket_): void;
        abstract handleUpdateTags(arg0: Internal.ClientboundUpdateTagsPacket_): void;
        abstract handleMerchantOffers(arg0: Internal.ClientboundMerchantOffersPacket_): void;
        abstract handleStopSoundEvent(arg0: Internal.ClientboundStopSoundPacket_): void;
        abstract handleRemoveMobEffect(arg0: Internal.ClientboundRemoveMobEffectPacket_): void;
        abstract handleSetSimulationDistance(arg0: Internal.ClientboundSetSimulationDistancePacket_): void;
        abstract handleSetChunkCacheCenter(arg0: Internal.ClientboundSetChunkCacheCenterPacket_): void;
        abstract handleDisguisedChat(arg0: Internal.ClientboundDisguisedChatPacket_): void;
        abstract handlePing(arg0: Internal.ClientboundPingPacket_): void;
        abstract handleBlockUpdate(arg0: Internal.ClientboundBlockUpdatePacket_): void;
        abstract handleRotateMob(arg0: Internal.ClientboundRotateHeadPacket_): void;
        abstract handleSystemChat(arg0: Internal.ClientboundSystemChatPacket_): void;
        abstract handleMovePlayer(arg0: Internal.ClientboundPlayerPositionPacket_): void;
        abstract handleDeleteChat(arg0: Internal.ClientboundDeleteChatPacket_): void;
        abstract handleAddEntity(arg0: Internal.ClientboundAddEntityPacket_): void;
        abstract handleSoundEntityEvent(arg0: Internal.ClientboundSoundEntityPacket_): void;
        abstract handleHorseScreenOpen(arg0: Internal.ClientboundHorseScreenOpenPacket_): void;
        abstract handleChangeDifficulty(arg0: Internal.ClientboundChangeDifficultyPacket_): void;
        abstract handleSetBorderWarningDelay(arg0: Internal.ClientboundSetBorderWarningDelayPacket_): void;
        abstract handleEntityEvent(arg0: Internal.ClientboundEntityEventPacket_): void;
        abstract handleEnabledFeatures(arg0: Internal.ClientboundUpdateEnabledFeaturesPacket_): void;
        abstract handleOpenSignEditor(arg0: Internal.ClientboundOpenSignEditorPacket_): void;
        abstract setTitleText(arg0: Internal.ClientboundSetTitleTextPacket_): void;
        abstract handleSetEntityData(arg0: Internal.ClientboundSetEntityDataPacket_): void;
        abstract handleBossUpdate(arg0: Internal.ClientboundBossEventPacket_): void;
        abstract handlePlaceRecipe(arg0: Internal.ClientboundPlaceGhostRecipePacket_): void;
        abstract handleGameEvent(arg0: Internal.ClientboundGameEventPacket_): void;
        abstract isAcceptingMessages(): boolean;
        abstract handleSoundEvent(arg0: Internal.ClientboundSoundPacket_): void;
        abstract handleSetEntityMotion(arg0: Internal.ClientboundSetEntityMotionPacket_): void;
        abstract handleContainerSetData(arg0: Internal.ClientboundContainerSetDataPacket_): void;
        abstract handlePlayerCombatEnd(arg0: Internal.ClientboundPlayerCombatEndPacket_): void;
        abstract handleMoveEntity(arg0: Internal.ClientboundMoveEntityPacket_): void;
        abstract handleLevelEvent(arg0: Internal.ClientboundLevelEventPacket_): void;
        abstract handlePlayerAbilities(arg0: Internal.ClientboundPlayerAbilitiesPacket_): void;
        shouldPropagateHandlingExceptions(): boolean;
        abstract handlePlayerCombatKill(arg0: Internal.ClientboundPlayerCombatKillPacket_): void;
        abstract handleSetBorderWarningDistance(arg0: Internal.ClientboundSetBorderWarningDistancePacket_): void;
        abstract handleAwardStats(arg0: Internal.ClientboundAwardStatsPacket_): void;
        abstract handleSetEntityPassengersPacket(arg0: Internal.ClientboundSetPassengersPacket_): void;
        abstract handleSelectAdvancementsTab(arg0: Internal.ClientboundSelectAdvancementsTabPacket_): void;
        abstract handleAddOrRemoveRecipes(arg0: Internal.ClientboundRecipePacket_): void;
        set actionBarText(arg0: Internal.ClientboundSetActionBarTextPacket_)
        set subtitleText(arg0: Internal.ClientboundSetSubtitleTextPacket_)
        set titlesAnimation(arg0: Internal.ClientboundSetTitlesAnimationPacket_)
        set titleText(arg0: Internal.ClientboundSetTitleTextPacket_)
        get acceptingMessages(): boolean
    }
    type ClientGamePacketListener_ = ClientGamePacketListener;
    class SmokeStackBlock$SmokeStackType {
        constructor(particleSpawnOffset: Vec3d_)
        constructor(particleSpawnOffset: Vec3d_, particleSpawnDelta: Vec3d_)
        constructor(xOffset: number, yOffset: number, zOffset: number)
        constructor(particleSpawnOffset: Vec3d_, particleSpawnDelta: Vec3d_, minParticles: number, maxParticles: number)
        constructor(particleSpawnOffset: Vec3d_, particleSpawnDelta: Vec3d_, minParticles: number, maxParticles: number, particleSpawnChance: number)
        getParticleSpawnDelta(): Vec3d;
        getParticleSpawnOffset(): Vec3d;
        get particleSpawnDelta(): Vec3d
        get particleSpawnOffset(): Vec3d
        particleSpawnOffset: Vec3d;
        particleSpawnDelta: Vec3d;
        particleSpawnChance: number;
        minParticles: number;
        maxParticles: number;
    }
    type SmokeStackBlock$SmokeStackType_ = SmokeStackBlock$SmokeStackType;
    class ClipContext$Fluid extends Internal.Enum<Internal.ClipContext$Fluid> {
        static valueOf($$0: string): Internal.ClipContext$Fluid;
        canPick($$0: Internal.FluidState_): boolean;
        static values(): Internal.ClipContext$Fluid[];
        static readonly SOURCE_ONLY: Internal.ClipContext$Fluid;
        static readonly WATER: Internal.ClipContext$Fluid;
        static readonly NONE: Internal.ClipContext$Fluid;
        static readonly ANY: Internal.ClipContext$Fluid;
    }
    type ClipContext$Fluid_ = "any" | "source_only" | ClipContext$Fluid | "water" | "none";
    class ModularAccumulatorBlockEntity extends Internal.SmartBlockEntity implements Internal.ThresholdSwitchObservable, Internal.IMultiTileEnergyContainer, Internal.IHaveGoggleInformation, Internal.IObserveTileEntity, Internal.IDebugDrawer, Internal.EnergyTransferable {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getCachedEnergy(side: Internal.Direction_): Internal.EnergyStorage;
        getTotalAccumulatorSize(): number;
        applySize(blocks: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        tickOutputSide(side: Internal.Direction_): void;
        setController(controller: BlockPos_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getEnergyStorage(side: Internal.Direction_): Internal.EnergyStorage;
        static getMaxHeight(): number;
        preventConnectivityUpdate(): void;
        observe(): void;
        onLoad(): void;
        drawDebug(): void;
        static getCapacityMultiplier(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        tickOutput(): void;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        setCache(side: Internal.Direction_, storage: Internal.EnergyStorage_): void;
        getWidth(): number;
        getMaxValue(): number;
        modifyExtraData(data: any): any;
        asComponentProvider(): Internal.ComponentProvider;
        getController(): BlockPos;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getMainConnectionAxis(): Internal.Direction$Axis;
        getEnergy(): Internal.InternalEnergyStorage;
        removeController(keepEnergy: boolean): void;
        isController(): boolean;
        setExtraData(data: any): void;
        sendDataImmediately(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getLastKnownPos(): BlockPos;
        format(i: number): Internal.MutableComponent;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        notifyMultiUpdated(): void;
        getExtraData(): any;
        setWidth(width: number): void;
        getSize(accumulator: number): number;
        getHeight(): number;
        updateCache(side: Internal.Direction_): void;
        getCurrentValue(): number;
        getMaxLength(longAxis: Internal.Direction$Axis_, width: number): number;
        getMinValue(): number;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        getMaxWidth(): number;
        setSize(accumulator: number, blocks: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        firstTick(): void;
        getControllerBE(): this;
        updateCache(): void;
        onObserved(player: Internal.ServerPlayer_, pack: Internal.ObservePacket_): void;
        getInfiniteBoundingBox(): Internal.AABB;
        tickAudio(): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getFillState(): number;
        hasAccumulator(): boolean;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        setHeight(height: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get totalAccumulatorSize(): number
        set controller(controller: BlockPos_)
        get maxHeight(): number
        get capacityMultiplier(): number
        get width(): number
        get maxValue(): number
        get controller(): BlockPos
        get mainConnectionAxis(): Internal.Direction$Axis
        get energy(): Internal.InternalEnergyStorage
        get controller(): boolean
        set extraData(data: any)
        get lastKnownPos(): BlockPos
        get extraData(): any
        set width(width: number)
        get height(): number
        get currentValue(): number
        get minValue(): number
        get maxWidth(): number
        get controllerBE(): Internal.ModularAccumulatorBlockEntity
        get infiniteBoundingBox(): Internal.AABB
        get fillState(): number
        set height(height: number)
        gauge: Internal.LerpedFloat;
    }
    type ModularAccumulatorBlockEntity_ = ModularAccumulatorBlockEntity;
    class EnumArgument$Info <T extends Internal.Enum<T>> implements Internal.ArgumentTypeInfo<Internal.EnumArgument<T>, Internal.EnumArgument$Info$Template<>> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToNetwork(template: Internal.EnumArgument$Info$Template_<>, buffer: Internal.FriendlyByteBuf_): void;
        unpack(argument: Internal.EnumArgument_<T>): Internal.EnumArgument$Info$Template<>;
        serializeToJson(template: Internal.EnumArgument$Info$Template_<>, json: Internal.JsonObject_): void;
        deserializeFromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.EnumArgument$Info$Template<>;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type EnumArgument$Info_<T extends Internal.Enum<T>> = EnumArgument$Info<T>;
    interface Quaternionfc {
        abstract slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): Quaternionf;
        abstract transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformPositiveY(arg0: Vec3f_): Vec3f;
        abstract transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
        abstract get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract conjugate(arg0: Quaternionf_): Quaternionf;
        abstract transform(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
        abstract transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract z(): number;
        abstract transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveY(arg0: Vec4f_): Vec4f;
        abstract transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract normalizedPositiveX(arg0: Vec3f_): Vec3f;
        abstract transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract invert(arg0: Quaternionf_): Quaternionf;
        abstract getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: Vec3f_): Vec3f;
        abstract lengthSquared(): number;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract transform(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
        abstract positiveZ(arg0: Vec3f_): Vec3f;
        abstract get(arg0: Quaternionf_): Quaternionf;
        abstract transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateX(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract transformUnitPositiveY(arg0: Vec4f_): Vec4f;
        abstract div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveZ(arg0: Vec3f_): Vec3f;
        abstract transformUnit(arg0: Vec4f_): Vec4f;
        abstract scale(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): Quaternionf;
        abstract rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
        abstract rotateLocalX(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): Quaternionf;
        abstract transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: Vec4f_): Vec4f;
        abstract get(arg0: Matrix4f_): Matrix4f;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract transform(arg0: Vec4f_): Vec4f;
        abstract transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract transformUnitPositiveY(arg0: Vec3f_): Vec3f;
        abstract normalize(arg0: Quaternionf_): Quaternionf;
        abstract transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        abstract mul(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract w(): number;
        abstract transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): Quaternionf;
        abstract normalizedPositiveY(arg0: Vec3f_): Vec3f;
        abstract transformPositiveZ(arg0: Vec4f_): Vec4f;
        abstract transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
        abstract transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): Quaternionf;
        abstract transform(arg0: Vec3f_): Vec3f;
        abstract transformUnitPositiveX(arg0: Vec4f_): Vec4f;
        abstract premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): Quaternionf;
        abstract get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
        abstract getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): Quaternionf;
        abstract transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): Quaternionf;
        abstract rotateLocalY(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract isFinite(): boolean;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveX(arg0: Vec3f_): Vec3f;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        abstract x(): number;
        abstract normalizedPositiveZ(arg0: Vec3f_): Vec3f;
        abstract conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnit(arg0: Vec3f_): Vec3f;
        abstract getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
        abstract angle(): number;
        abstract transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract get(arg0: Matrix3f_): Matrix3f;
        abstract rotateZ(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract positiveX(arg0: Vec3f_): Vec3f;
        abstract rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): Quaternionf;
        abstract getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
        abstract get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverse(arg0: Vec4f_): Vec4f;
        abstract getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
        abstract nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
        abstract difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract transformPositiveX(arg0: Vec3f_): Vec3f;
        abstract transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateLocalZ(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): Quaternionf;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): Quaternionf;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): Quaternionf;
        abstract y(): number;
        abstract transformInverse(arg0: Vec3f_): Vec3f;
        abstract transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): Quaternionf;
        abstract transformPositiveX(arg0: Vec4f_): Vec4f;
        abstract getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract positiveY(arg0: Vec3f_): Vec3f;
        abstract transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
        abstract get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateY(arg0: number, arg1: Quaternionf_): Quaternionf;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        get finite(): boolean
    }
    type Quaternionfc_ = Quaternionfc;
    class ProjectileImpactEvent$ImpactResult extends Internal.Enum<Internal.ProjectileImpactEvent$ImpactResult> {
        static valueOf(name: string): Internal.ProjectileImpactEvent$ImpactResult;
        static values(): Internal.ProjectileImpactEvent$ImpactResult[];
        static readonly DEFAULT: Internal.ProjectileImpactEvent$ImpactResult;
        static readonly SKIP_ENTITY: Internal.ProjectileImpactEvent$ImpactResult;
        static readonly STOP_AT_CURRENT: Internal.ProjectileImpactEvent$ImpactResult;
        static readonly STOP_AT_CURRENT_NO_DAMAGE: Internal.ProjectileImpactEvent$ImpactResult;
    }
    type ProjectileImpactEvent$ImpactResult_ = ProjectileImpactEvent$ImpactResult | "stop_at_current" | "stop_at_current_no_damage" | "skip_entity" | "default";
    class LootTableProvider implements Internal.DataProvider, Internal.LootTableProviderAccessor {
        constructor($$0: Internal.PackOutput_, $$1: Internal.Set_<ResourceLocation>, $$2: Internal.List_<Internal.LootTableProvider$SubProviderEntry>)
        run($$0: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        getName(): string;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        setSubProviders(arg0: Internal.List_<any>): void;
        get name(): string
        set subProviders(arg0: Internal.List_<any>)
        subProviders: Internal.List<Internal.LootTableProvider$SubProviderEntry>;
        readonly pathProvider: Internal.PackOutput$PathProvider;
        static readonly LOGGER: Internal.Log4jLogger;
        readonly requiredTables: Internal.Set<ResourceLocation>;
    }
    type LootTableProvider_ = LootTableProvider;
    class ExperienceOrb extends Internal.Entity implements Internal.ExperienceOrbAccess, Internal.IClumpedOrb {
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: number)
        constructor($$0: Internal.EntityType_<Internal.ExperienceOrb>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        handler$bkd000$clumps$repairPlayerItems(player: Internal.Player_, actualValue: number, cir: Internal.CallbackInfoReturnable_<any>): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        clumps$setCount(arg0: number): void;
        localvar$bkd000$clumps$captureCurrentEntry(entry: Internal.Map$Entry_<any, any>): Internal.Map$Entry<any, any>;
        isOnScoreboardTeam(teamId: string): boolean;
        handler$bkd000$clumps$playerTouch(player: Internal.Player_, ci: Internal.CallbackInfo_): void;
        getValue(): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        method_5652($$0: Internal.CompoundTag_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        handler$bkd000$clumps$readAdditionalSaveData(compoundTag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        getFacing(): Internal.Direction;
        clumps$setClumpedMap(map: Internal.Map_<any, any>): void;
        canRiderInteract(): boolean;
        getIcon(): number;
        method_5749($$0: Internal.CompoundTag_): void;
        clumps$getClumpedMap(): Internal.Map<any, any>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        playSound(id: Internal.SoundEvent_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        clumps$resolve(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        handler$bkd000$clumps$addAdditionalSaveData(compoundTag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        sophisticatedInvalidateCaps(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static award($$0: Internal.ServerLevel_, $$1: Vec3d_, $$2: number): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        handler$bkd000$clumps$merge(secondaryOrb: Internal.ExperienceOrb_, ci: Internal.CallbackInfo_): void;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        static getExperienceValue($$0: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        clumps$setAge(arg0: number): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        clumps$getAge(): number;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        runCommand(command: string): number;
        get value(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        get facing(): Internal.Direction
        get icon(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        clumps$clumpedMap: Internal.Map<any, any>;
        clumps$currentEntry: Internal.Map$Entry<any, any>;
    }
    type ExperienceOrb_ = ExperienceOrb;
    class ServerboundPaddleBoatPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: boolean, $$1: boolean)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getRight(): boolean;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        getLeft(): boolean;
        get right(): boolean
        get skippable(): boolean
        get left(): boolean
    }
    type ServerboundPaddleBoatPacket_ = ServerboundPaddleBoatPacket;
    abstract class BlockEntity implements Internal.BlockEntityAccessor, Internal.BlockEntityExtensions, Internal.AttachmentTargetImpl, io.wispforest.owo.mixin.ui.access.BlockEntityAccessor, Internal.ETFEntity, Internal.Cullable, Internal.INBTSerializableCompound, Internal.ComponentProvider, Internal.RenderDataBlockEntity, Internal.RenderAttachmentBlockEntity, Internal.AccessorBlockEntity, Internal.ComparatorTracker {
        constructor($$0: Internal.BlockEntityType_<any>, $$1: BlockPos_, $$2: Internal.BlockState_)
        getAttached(type: Internal.AttachmentType_<any>): any;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        etf$getWorld(): Internal.Level;
        getRenderAttachmentData(): any;
        getUpdateTag(): Internal.CompoundTag;
        etf$getType(): Internal.EntityType<any>;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setLevel($$0: Internal.Level_): void;
        etf$isBlockEntity(): boolean;
        /**
         * @deprecated
        */
        setBlockState($$0: Internal.BlockState_): void;
        hasAttached(type: Internal.AttachmentType_<any>): boolean;
        getBlockPos(): BlockPos;
        etf$getNbt(): Internal.CompoundTag;
        isRemoved(): boolean;
        load($$0: Internal.CompoundTag_): void;
        setChanged(): void;
        setCulled(value: boolean): void;
        etf$getBlockPos(): BlockPos;
        onLoad(): void;
        saveWithoutMetadata(): Internal.CompoundTag;
        fillCrashReportCategory($$0: Internal.CrashReportCategory_): void;
        setTimeout(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        etf$getBlockY(): number;
        isOutOfCamera(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        etf$getHandItems(): Internal.Iterable<any>;
        etf$getArmorItems(): Internal.Iterable<any>;
        invalidateCaps(): void;
        etf$canBeBright(): boolean;
        handler$zzl000$porting_lib_base$port_lib$invalidate(ci: Internal.CallbackInfo_): void;
        getBlockState(): Internal.BlockState;
        toComponentPacket(key: Internal.ComponentKey_<any>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        setRemoved(): void;
        asComponentProvider(): Internal.ComponentProvider;
        etf$getEntityKey(): string;
        etf$getPose(): Internal.Pose;
        isCulled(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getType(): Internal.BlockEntityType<any>;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        etf$hasCustomName(): boolean;
        etf$getOptifineId(): number;
        getCustomData(): Internal.CompoundTag;
        static loadStatic($$0: BlockPos_, $$1: Internal.BlockState_, $$2: Internal.CompoundTag_): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        handler$bgd000$botarium$serializeData(compoundTag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        getComponentContainer(): Internal.ComponentContainer;
        etf$getCustomName(): net.minecraft.network.chat.Component;
        fabric_writeAttachmentsToNbt(nbt: Internal.CompoundTag_): void;
        saveWithId(): Internal.CompoundTag;
        static getPosFromTag($$0: Internal.CompoundTag_): BlockPos;
        etf$distanceTo(entity: Internal.Entity_): number;
        hasAnyComparatorNearby(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        setOutOfCamera(value: boolean): void;
        saveToItem($$0: Internal.ItemStack_): void;
        static addEntityType($$0: Internal.CompoundTag_, $$1: Internal.BlockEntityType_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onComparatorAdded(direction: Internal.Direction_, offset: number): void;
        getLevel(): Internal.Level;
        getUpdatePacket(): Internal.Packet<Internal.ClientGamePacketListener>;
        fabric_hasPersistentAttachments(): boolean;
        clearRemoved(): void;
        onlyOpCanSetNbt(): boolean;
        port_lib$saveMetadata(arg0: Internal.CompoundTag_): void;
        owo$setCachedState(arg0: Internal.BlockState_): void;
        fabric_getAttachments(): Internal.Map<any, any>;
        saveWithFullMetadata(): Internal.CompoundTag;
        handler$bgd000$botarium$deserializeData(compoundTag: Internal.CompoundTag_, ci: Internal.CallbackInfo_): void;
        deserializeNBT(arg0: Internal.Tag_): void;
        triggerEvent($$0: number, $$1: number): boolean;
        hasLevel(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        etf$getUuid(): Internal.UUID;
        getRecipientsForComponentSync(): Internal.Iterable<any>;
        deserializeNBT(state: Internal.BlockState_, nbt: Internal.CompoundTag_): void;
        etf$getScoreboardTeam(): Internal.Team;
        isForcedVisible(): boolean;
        serializeNBT(): Internal.CompoundTag;
        setAttached(type: Internal.AttachmentType_<any>, value: any): any;
        fabric_readAttachmentsFromNbt(nbt: Internal.CompoundTag_): void;
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setWorldPosition(arg0: BlockPos_): void;
        getRenderData(): any;
        etf$getItemsEquipped(): Internal.Iterable<any>;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        etf$getVelocity(): Vec3d;
        get renderAttachmentData(): any
        get updateTag(): Internal.CompoundTag
        set level($$0: Internal.Level_)
        /**
         * @deprecated
        */
        set blockState($$0: Internal.BlockState_)
        get blockPos(): BlockPos
        get removed(): boolean
        set culled(value: boolean)
        get outOfCamera(): boolean
        get blockState(): Internal.BlockState
        get culled(): boolean
        get type(): Internal.BlockEntityType<any>
        get customData(): Internal.CompoundTag
        get componentContainer(): Internal.ComponentContainer
        set outOfCamera(value: boolean)
        get level(): Internal.Level
        get updatePacket(): Internal.Packet<Internal.ClientGamePacketListener>
        get recipientsForComponentSync(): Internal.Iterable<any>
        get forcedVisible(): boolean
        set worldPosition(arg0: BlockPos_)
        get renderData(): any
    }
    type BlockEntity_ = BlockEntity;
    class RegularEnumSet <E extends Internal.Enum<E>> extends Internal.EnumSet<E> {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        add(arg0: E): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        abstract toArray<T>(arg0: T[]): T[];
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        removeIf(arg0: Internal.Predicate_<E>): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
    }
    type RegularEnumSet_<E extends Internal.Enum<E>> = RegularEnumSet<E>;
    interface DocumentFragment extends org.w3c.dom.Node {
        abstract getPrefix(): string;
        abstract getFirstChild(): org.w3c.dom.Node;
        abstract getLastChild(): org.w3c.dom.Node;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract cloneNode(arg0: boolean): org.w3c.dom.Node;
        abstract normalize(): void;
        abstract getOwnerDocument(): Internal.Document;
        abstract hasChildNodes(): boolean;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract hasAttributes(): boolean;
        abstract removeChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNodeValue(): string;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract appendChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNamespaceURI(): string;
        abstract getLocalName(): string;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): org.w3c.dom.Node;
        abstract lookupPrefix(arg0: string): string;
        abstract setPrefix(arg0: string): void;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getTextContent(): string;
        abstract getChildNodes(): Internal.NodeList;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract getNodeType(): number;
        abstract setNodeValue(arg0: string): void;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract getNextSibling(): org.w3c.dom.Node;
        abstract getUserData(arg0: string): any;
        abstract getParentNode(): org.w3c.dom.Node;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        get prefix(): string
        get firstChild(): org.w3c.dom.Node
        get lastChild(): org.w3c.dom.Node
        get ownerDocument(): Internal.Document
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        get namespaceURI(): string
        get localName(): string
        get previousSibling(): org.w3c.dom.Node
        set prefix(arg0: string)
        get textContent(): string
        get childNodes(): Internal.NodeList
        get attributes(): Internal.NamedNodeMap
        get nodeType(): number
        set nodeValue(arg0: string)
        get baseURI(): string
        get nextSibling(): org.w3c.dom.Node
        get parentNode(): org.w3c.dom.Node
    }
    type DocumentFragment_ = DocumentFragment;
    interface ThresholdSwitchObservable {
        abstract getMinValue(): number;
        abstract getMaxValue(): number;
        abstract format(arg0: number): Internal.MutableComponent;
        abstract getCurrentValue(): number;
        get minValue(): number
        get maxValue(): number
        get currentValue(): number
    }
    type ThresholdSwitchObservable_ = ThresholdSwitchObservable;
    interface ItemFrameEntityKJS extends Internal.EntityKJS {
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        isLiving(): boolean;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        attack(hp: number): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        getMotionZ(): number;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type ItemFrameEntityKJS_ = ItemFrameEntityKJS;
    class SignalBlockEntity$OverlayState extends Internal.Enum<Internal.SignalBlockEntity$OverlayState> {
        static values(): Internal.SignalBlockEntity$OverlayState[];
        static valueOf(name: string): Internal.SignalBlockEntity$OverlayState;
        static readonly DUAL: Internal.SignalBlockEntity$OverlayState;
        static readonly RENDER: Internal.SignalBlockEntity$OverlayState;
        static readonly SKIP: Internal.SignalBlockEntity$OverlayState;
    }
    type SignalBlockEntity$OverlayState_ = "dual" | "skip" | SignalBlockEntity$OverlayState | "render";
    class SlimeVineBlock$VineStage extends Internal.Enum<Internal.SlimeVineBlock$VineStage> implements Internal.StringRepresentable {
        static values(): Internal.SlimeVineBlock$VineStage[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.SlimeVineBlock$VineStage;
        getSerializedName(): string;
        get serializedName(): string
        static readonly START: Internal.SlimeVineBlock$VineStage;
        static readonly END: Internal.SlimeVineBlock$VineStage;
        static readonly MIDDLE: Internal.SlimeVineBlock$VineStage;
    }
    type SlimeVineBlock$VineStage_ = "start" | "middle" | "end" | SlimeVineBlock$VineStage;
    interface ScreenKeyboardEvents$AfterKeyPress {
        abstract afterKeyPress(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenKeyboardEvents$AfterKeyPress_ = ScreenKeyboardEvents$AfterKeyPress;
    class MushroomBlock extends Internal.BushBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.ResourceKey_<Internal.ConfiguredFeature<any, any>>)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        growMushroom($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.RandomSource_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MushroomBlock_ = MushroomBlock;
    class IafDragonFlightManager {
        constructor(dragon: Internal.EntityDragonBase_)
        getFlightTarget(): Vec3d;
        static approachDegrees(number: number, max: number, min: number): number;
        static degreesDifferenceAbs(f1: number, f2: number): number;
        static approach(number: number, max: number, min: number): number;
        update(): void;
        setFlightTarget(target: Vec3d_): void;
        onSetAttackTarget(LivingEntityIn: Internal.LivingEntity_): void;
        get flightTarget(): Vec3d
        set flightTarget(target: Vec3d_)
    }
    type IafDragonFlightManager_ = IafDragonFlightManager;
    interface GameEventListener {
        abstract getListenerSource(): Internal.PositionSource;
        abstract getListenerRadius(): number;
        abstract handleGameEvent(arg0: Internal.ServerLevel_, arg1: Internal.GameEvent_, arg2: Internal.GameEvent$Context_, arg3: Vec3d_): boolean;
        getDeliveryMode(): Internal.GameEventListener$DeliveryMode;
        get listenerSource(): Internal.PositionSource
        get listenerRadius(): number
        get deliveryMode(): Internal.GameEventListener$DeliveryMode
    }
    type GameEventListener_ = GameEventListener;
    interface Guard {
        abstract checkGuard(arg0: any): void;
        (arg0: any): void;
    }
    type Guard_ = Guard;
    class WoodType extends Internal.Record {
        constructor($$0: string, $$1: Internal.BlockSetType_, $$2: SoundType_, $$3: SoundType_, $$4: Internal.SoundEvent_, $$5: Internal.SoundEvent_)
        constructor($$0: string, $$1: Internal.BlockSetType_)
        name(): string;
        fenceGateClose(): Internal.SoundEvent;
        static values(): Internal.Stream<Internal.WoodType>;
        static register($$0: Internal.WoodType_): Internal.WoodType;
        fenceGateOpen(): Internal.SoundEvent;
        setType(): Internal.BlockSetType;
        soundType(): SoundType;
        hangingSignSoundType(): SoundType;
        static readonly SPRUCE: Internal.WoodType;
        static readonly BAMBOO: Internal.WoodType;
        static readonly ACACIA: Internal.WoodType;
        static readonly JUNGLE: Internal.WoodType;
        static readonly DARK_OAK: Internal.WoodType;
        static readonly CRIMSON: Internal.WoodType;
        static readonly OAK: Internal.WoodType;
        static readonly CHERRY: Internal.WoodType;
        static readonly MANGROVE: Internal.WoodType;
        static readonly BIRCH: Internal.WoodType;
        static readonly WARPED: Internal.WoodType;
    }
    type WoodType_ = WoodType;
    abstract class ContainerAdjacentNetworkedPipeBlock extends Internal.NetworkedPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        onNeighborChange(state: Internal.BlockState_, level: Internal.LevelReader_, pos: BlockPos_, neighbor: BlockPos_): void;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.EnumProperty<Internal.FacingOrNone>;
    }
    type ContainerAdjacentNetworkedPipeBlock_ = ContainerAdjacentNetworkedPipeBlock;
    class HandcarBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type HandcarBlock_ = HandcarBlock;
    interface Double2ReferenceFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.DoubleFunction<V> {
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Double2ShortFunction;
        composeShort(arg0: Internal.Short2DoubleFunction_): Internal.Short2ReferenceFunction<V>;
        composeLong(arg0: Internal.Long2DoubleFunction_): Internal.Long2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Double2ByteFunction;
        remove(arg0: number): V;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Double2DoubleFunction;
        put(arg0: number, arg1: V): V;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Double2LongFunction;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        composeChar(arg0: Internal.Char2DoubleFunction_): Internal.Char2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Double2IntFunction;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Double2ObjectFunction<T>;
        apply(arg0: number): V;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        composeInt(arg0: Internal.Int2DoubleFunction_): Internal.Int2ReferenceFunction<V>;
        composeByte(arg0: Internal.Byte2DoubleFunction_): Internal.Byte2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        abstract get(arg0: number): V;
        containsKey(arg0: number): boolean;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Double2ReferenceFunction<T>;
        getOrDefault(arg0: number, arg1: V): V;
        composeObject<T>(arg0: Internal.Object2DoubleFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        size(): number;
        composeDouble(arg0: Internal.Double2DoubleFunction_): this;
        composeFloat(arg0: Internal.Float2DoubleFunction_): Internal.Float2ReferenceFunction<V>;
        clear(): void;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        defaultReturnValue(): V;
        composeReference<T>(arg0: Internal.Reference2DoubleFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Double2CharFunction;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Double2FloatFunction;
        (arg0: number): V;
    }
    type Double2ReferenceFunction_<V> = Double2ReferenceFunction<V>;
    class NixieTubeBlockEntity extends Internal.SmartBlockEntity implements Internal.IOverridableSignal {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRedstoneStrength(): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        reactsToRedstone(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        displayEmptyText(nixiePositionInRow: number): void;
        getFullText(): Internal.MutableComponent;
        displayCustomText(tagElement: string, nixiePositionInRow: number): void;
        clearCustomText(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        updateDisplayedStrings(): void;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        railways$refresh(signalBE: Internal.SignalBlockEntity_, state: Internal.SignalBlockEntity$SignalState_, ticks: number): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        railways$getOverriddenState(): Internal.Optional<any>;
        railways$refresh(signalBE: Internal.SignalBlockEntity_, state: Internal.SignalBlockEntity$SignalState_, ticks: number, distantSignal: boolean): void;
        updateRedstoneStrength(signalStrength: number): void;
        getDisplayedStrings(): Internal.Couple<string>;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get redstoneStrength(): number
        get fullText(): Internal.MutableComponent
        get infiniteBoundingBox(): Internal.AABB
        get displayedStrings(): Internal.Couple<string>
        computerSignal: Internal.NixieTubeBlockEntity$ComputerSignal;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        signalState: Internal.SignalBlockEntity$SignalState;
    }
    type NixieTubeBlockEntity_ = NixieTubeBlockEntity;
    interface Shearable {
        abstract shear(arg0: Internal.SoundSource_): void;
        abstract readyForShearing(): boolean;
    }
    type Shearable_ = Shearable;
    class ChunkHolder implements Internal.ChunkHolderExtended {
        constructor($$0: Internal.ChunkPos_, $$1: number, $$2: Internal.LevelHeightAccessor_, $$3: Internal.LevelLightEngine_, $$4: any_, $$5: Internal.ChunkHolder$PlayerProvider_)
        getTickingChunk(): Internal.LevelChunk;
        getFullChunk(): Internal.LevelChunk;
        getTicketLevel(): number;
        getChunkToSave(): Internal.CompletableFuture<Internal.ChunkAccess>;
        getLastAvailable(): Internal.ChunkAccess;
        setFutureForStatus(index: number, future: Internal.CompletableFuture_<any>): void;
        wasAccessibleSinceLastSave(): boolean;
        getFutureIfPresent($$0: Internal.ChunkStatus_): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        broadcastChanges($$0: Internal.LevelChunk_): void;
        getOrScheduleFuture($$0: Internal.ChunkStatus_, $$1: Internal.ChunkMap_): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getEntityTickingChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getFutureByStatus(index: number): Internal.CompletableFuture<any>;
        getLastAvailableStatus(): Internal.ChunkStatus;
        getFullStatus(): Internal.FullChunkStatus;
        getFutureIfPresentUnchecked($$0: Internal.ChunkStatus_): Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        updateLastAccessTime(time: number): boolean;
        getQueueLevel(): number;
        getFullChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        refreshAccessibility(): void;
        getPos(): Internal.ChunkPos;
        updateChunkToSave($$0: Internal.CompletableFuture_<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>, $$1: string): void;
        setTicketLevel($$0: number): void;
        replaceProtoChunk($$0: Internal.ImposterProtoChunk_): void;
        blockChanged($$0: BlockPos_): void;
        sectionLightChanged($$0: Internal.LightLayer_, $$1: number): void;
        getTickingChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>;
        getAllFutures(): Internal.List<com.mojang.datafixers.util.Pair<Internal.ChunkStatus, Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>>>;
        get tickingChunk(): Internal.LevelChunk
        get fullChunk(): Internal.LevelChunk
        get ticketLevel(): number
        get chunkToSave(): Internal.CompletableFuture<Internal.ChunkAccess>
        get lastAvailable(): Internal.ChunkAccess
        get entityTickingChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>
        get lastAvailableStatus(): Internal.ChunkStatus
        get fullStatus(): Internal.FullChunkStatus
        get queueLevel(): number
        get fullChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>
        get pos(): Internal.ChunkPos
        set ticketLevel($$0: number)
        get tickingChunkFuture(): Internal.CompletableFuture<Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>>
        get allFutures(): Internal.List<com.mojang.datafixers.util.Pair<Internal.ChunkStatus, Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>>>
        chunkToSave: Internal.CompletableFuture<Internal.ChunkAccess>;
        static readonly UNLOADED_CHUNK_FUTURE: Internal.CompletableFuture<Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>>;
        static readonly UNLOADED_CHUNK: Internal.Either<Internal.ChunkAccess, Internal.ChunkHolder$ChunkLoadingFailure>;
        static readonly UNLOADED_LEVEL_CHUNK: Internal.Either<Internal.LevelChunk, Internal.ChunkHolder$ChunkLoadingFailure>;
    }
    type ChunkHolder_ = ChunkHolder;
    class InfestedBlock extends Internal.Block {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static isCompatibleHostBlock($$0: Internal.BlockState_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static infestedStateByHost($$0: Internal.BlockState_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        hostStateByInfested($$0: Internal.BlockState_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getHostBlock(): Internal.Block;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get hostBlock(): Internal.Block
    }
    type InfestedBlock_ = InfestedBlock;
    /**
     * @deprecated
    */
    interface ItemPropertyFunction {
        abstract call(arg0: Internal.ItemStack_, arg1: Internal.ClientLevel_, arg2: Internal.LivingEntity_, arg3: number): number;
        (arg0: Internal.ItemStack, arg1: Internal.ClientLevel, arg2: Internal.LivingEntity, arg3: number): number;
    }
    type ItemPropertyFunction_ = ItemPropertyFunction;
    class ObsidianSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type ObsidianSplatterFeature_ = ObsidianSplatterFeature;
    interface AccessorSmithingTrimRecipe {
        abstract getTemplate(): Internal.Ingredient;
        abstract getBase(): Internal.Ingredient;
        abstract getAddition(): Internal.Ingredient;
        get template(): Internal.Ingredient
        get base(): Internal.Ingredient
        get addition(): Internal.Ingredient
    }
    type AccessorSmithingTrimRecipe_ = AccessorSmithingTrimRecipe;
    class AgriSoil extends Internal.Record implements Internal.MagnifyingInspectable {
        constructor(mods: Internal.List_<string>, variants: Internal.List_<Internal.AgriSoilVariant>, humidity: Internal.AgriSoilCondition$Humidity_, acidity: Internal.AgriSoilCondition$Acidity_, nutrients: Internal.AgriSoilCondition$Nutrients_, growthModifier: number)
        isVariant(item: Internal.Item_): boolean;
        isVariant(blockState: Internal.BlockState_): boolean;
        humidity(): Internal.AgriSoilCondition$Humidity;
        mods(): Internal.List<string>;
        acidity(): Internal.AgriSoilCondition$Acidity;
        nutrients(): Internal.AgriSoilCondition$Nutrients;
        variants(): Internal.List<Internal.AgriSoilVariant>;
        growthModifier(): number;
        static builder(): Internal.AgriSoil$Builder;
        addMagnifyingTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): void;
        static readonly CODEC: Internal.Codec<Internal.AgriSoil>;
    }
    type AgriSoil_ = Special.Soils | AgriSoil;
    class DepositUpgradeItem extends Internal.UpgradeItemBase<Internal.DepositUpgradeWrapper> {
        constructor(filterSlotCount: Internal.IntSupplier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getType(): Internal.UpgradeType<Internal.DepositUpgradeWrapper>;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get type(): Internal.UpgradeType<Internal.DepositUpgradeWrapper>
        get filterSlotCount(): number
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DepositUpgradeItem_ = DepositUpgradeItem;
    interface TickAccess <T> {
        abstract count(): number;
        abstract schedule(arg0: Internal.ScheduledTick_<T>): void;
        abstract hasScheduledTick(arg0: BlockPos_, arg1: T): boolean;
    }
    type TickAccess_<T> = TickAccess<T>;
    class TrackBlockEntityTilt {
        constructor(blockEntity: Internal.TrackBlockEntity_)
        undoSmoothing(): void;
        getYOffsetForAxisEnd(end: Vec3d_): number;
        restoreToOriginalCurve(bezierConnection: Internal.BezierConnection_): Internal.BezierConnection;
        captureSmoothingHandles(): void;
        tryApplySmoothing(): void;
        static compareHandles(handle1: Vec3d_, handle2: Vec3d_): boolean;
        smoothingAngle: Internal.Optional<number>;
    }
    type TrackBlockEntityTilt_ = TrackBlockEntityTilt;
    interface Quaterniondc {
        abstract rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract mul(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformPositiveY(arg0: Vec3f_): Vec3f;
        abstract transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract transform(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
        abstract transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract x(): number;
        abstract transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract mul(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveY(arg0: Vec4f_): Vec4f;
        abstract dot(arg0: Internal.Quaterniondc_): number;
        abstract transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): Internal.Quaterniond;
        abstract premul(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract rotateY(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: Vec3f_): Vec3f;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract transform(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract positiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract get(arg0: Quaternionf_): Quaternionf;
        abstract transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnitPositiveY(arg0: Vec4f_): Vec4f;
        abstract div(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract rotateTo(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract angle(): number;
        abstract transformPositiveZ(arg0: Vec3f_): Vec3f;
        abstract transformUnit(arg0: Vec4f_): Vec4f;
        abstract transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: Vec4f_): Vec4f;
        abstract get(arg0: Matrix4f_): Matrix4f;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract conjugate(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transform(arg0: Vec4f_): Vec4f;
        abstract transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveY(arg0: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract y(): number;
        abstract lengthSquared(): number;
        abstract get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
        abstract transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract normalizedPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract transformPositiveZ(arg0: Vec4f_): Vec4f;
        abstract transformUnit(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract getEulerAnglesZYX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateZ(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
        abstract transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transform(arg0: Vec3f_): Vec3f;
        abstract equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract positiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveX(arg0: Vec4f_): Vec4f;
        abstract rotateLocalZ(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract getEulerAnglesZXY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
        abstract transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateAxis(arg0: number, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): Internal.Quaterniond;
        abstract z(): number;
        abstract transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract isFinite(): boolean;
        abstract nlerp(arg0: Internal.Quaterniondc_, arg1: number, arg2: Internal.Quaterniond_): Internal.Quaterniond;
        abstract nlerpIterative(arg0: Internal.Quaterniondc_, arg1: number, arg2: number, arg3: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnitPositiveX(arg0: Vec3f_): Vec3f;
        abstract equals(arg0: Internal.Quaterniondc_, arg1: number): boolean;
        abstract normalize(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
        abstract normalizedPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnit(arg0: Vec3f_): Vec3f;
        abstract conjugateBy(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract get(arg0: Matrix3f_): Matrix3f;
        abstract rotateLocalY(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
        abstract transformInverse(arg0: Vec4f_): Vec4f;
        abstract premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformPositiveX(arg0: Vec3f_): Vec3f;
        abstract transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
        abstract transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract getEulerAnglesXYZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
        abstract add(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
        abstract difference(arg0: Internal.Quaterniondc_, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract slerp(arg0: Internal.Quaterniondc_, arg1: number, arg2: Internal.Quaterniond_): Internal.Quaterniond;
        abstract w(): number;
        abstract transformInverse(arg0: Vec3f_): Vec3f;
        abstract transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
        abstract normalizedPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformPositiveX(arg0: Vec4f_): Vec4f;
        abstract rotateX(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract invert(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Quaterniond_): Internal.Quaterniond;
        abstract lookAlong(arg0: Internal.Vector3dc_, arg1: Internal.Vector3dc_, arg2: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
        abstract rotateLocalX(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract getEulerAnglesYXZ(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract positiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
        abstract transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
        abstract get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
        abstract scale(arg0: number, arg1: Internal.Quaterniond_): Internal.Quaterniond;
        abstract transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
        abstract transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
        get finite(): boolean
    }
    type Quaterniondc_ = Quaterniondc;
    class ShockPendantItem extends Internal.PendantItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ShockPendantItem_ = ShockPendantItem;
    class InscriberProcessType extends Internal.Enum<Internal.InscriberProcessType> {
        static valueOf(name: string): Internal.InscriberProcessType;
        static values(): Internal.InscriberProcessType[];
        static readonly PRESS: Internal.InscriberProcessType;
        static readonly INSCRIBE: Internal.InscriberProcessType;
    }
    type InscriberProcessType_ = "inscribe" | "press" | InscriberProcessType;
    class RegistryAccess$ImmutableRegistryAccess implements Internal.BiomeModificationMarker, Internal.RegistryAccess {
        constructor($$0: Internal.Map_<Internal.ResourceKey<Internal.Registry<any>>, Internal.Registry<any>>)
        constructor($$0: Internal.List_<Internal.Registry<any>>)
        constructor($$0: Internal.Stream_<Internal.RegistryAccess$RegistryEntry<any>>)
        lookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Optional<Internal.HolderLookup$RegistryLookup<T>>;
        fabric_markModified(): void;
        allRegistriesLifecycle(): Internal.Lifecycle;
        static create($$0: Internal.Stream_<Internal.HolderLookup$RegistryLookup<any>>): Internal.HolderLookup$Provider;
        registry<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.Registry<E>>;
        lookupOrThrow<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup$RegistryLookup<T>;
        registryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Registry<E>;
        registries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        freeze(): Internal.RegistryAccess$Frozen;
        asGetterLookup(): Internal.HolderGetter$Provider;
        static fromRegistryOfRegistries($$0: Internal.Registry_<Internal.Registry<any>>): Internal.RegistryAccess$Frozen;
    }
    type RegistryAccess$ImmutableRegistryAccess_ = RegistryAccess$ImmutableRegistryAccess;
    class MatchingFluidsPredicate extends Internal.StateTestingPredicate {
        constructor($$0: Vec3i_, $$1: Internal.HolderSet_<Internal.Fluid>)
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.MatchingFluidsPredicate>;
    }
    type MatchingFluidsPredicate_ = MatchingFluidsPredicate;
    interface LayoutElement {
        abstract getX(): number;
        abstract getWidth(): number;
        abstract getY(): number;
        abstract setY(arg0: number): void;
        abstract setX(arg0: number): void;
        setPosition($$0: number, $$1: number): void;
        abstract getHeight(): number;
        getRectangle(): Internal.ScreenRectangle;
        abstract visitWidgets(arg0: Internal.Consumer_<Internal.AbstractWidget>): void;
        get x(): number
        get width(): number
        get y(): number
        set y(arg0: number)
        set x(arg0: number)
        get height(): number
        get rectangle(): Internal.ScreenRectangle
    }
    type LayoutElement_ = LayoutElement;
    class MouseButton {
        static get(i: number): Internal.MouseButton;
        isLeft(): boolean;
        isRight(): boolean;
        isMiddle(): boolean;
        getId(): number;
        get left(): boolean
        get right(): boolean
        get middle(): boolean
        get id(): number
        static readonly MIDDLE: Internal.MouseButton;
        readonly id: number;
        static readonly BACK: Internal.MouseButton;
        static readonly LEFT: Internal.MouseButton;
        static readonly NEXT: Internal.MouseButton;
        static readonly RIGHT: Internal.MouseButton;
    }
    type MouseButton_ = MouseButton;
}
declare namespace it.unimi.dsi.fastutil.ints {
    interface IntBinaryOperator extends Internal.IntBinaryOperator, Internal.BinaryOperator<number> {
        abstract apply(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        apply(arg0: any, arg1: any): any;
        andThen<V>(arg0: Internal.Function_<number, V>): Internal.BiFunction<number, number, V>;
        minBy<T>(arg0: Internal.Comparator_<T>): Internal.BinaryOperator<T>;
        maxBy<T>(arg0: Internal.Comparator_<T>): Internal.BinaryOperator<T>;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        apply(arg0: number, arg1: number): number;
        (arg0: number, arg1: number): number;
    }
    type IntBinaryOperator_ = IntBinaryOperator;
}
